# Generadors de Recamán

La seqüència de Recamán amb paràmetre $k$ va ser descrita pel matemàtic
colombià Bernardo Recamán Santos i és definada així:

$$a_n = \begin{cases}
    0 & \text{ si $n=0$,}\\
    a_{n-1}-n-k & \text{ si $n>0$ i $a_{n-1}-n-k>0$ i $a_{n-1}-n-k$ no ha
aparagut abans,}\\
    a_{n-1}+n+k & \text{ altrament.}\\
\end{cases}$$

Així, els deu primers termes de la seqüència de Recamán amb $k=0$ són
\[0, 1, 3, 6, 2, 7, 13, 20, 12, 21\] i els deu primers termes de la
seqüència de Recamán amb $k=2$ són \[0, 3, 7, 2, 8, 1, 9, 18, 28, 17\].

1.  Escriviu una funció

            def recaman(k: int) -> Iterator[int]

    que, donat un natural $k$, generi la seqüència de Recamán amb
    paràmetre $k$.

2.  Escriviu una funció

            def recaman_from(k: int, n: int) -> Iterator[int]

    que, donat uns naturals $k$ i $n$, generi la seqüència de Recamán
    amb paràmetre $k$ començant pel terme $n$-èsim.

3.  Escriviu una funció

            def recaman_first_completion(k: int, x: int) -> int

    que, donat uns naturals $k$ i $x$, retorni el primer $n$ tal que
    $\{a_0,...,a_n\}$ conté tots els naturals fins a $x$
    ($\{0,...,x\}$). Assumiu que aquest valor existeix, malgrat que
    aquest fet no ha estat encara mai demostrat.

## Observacions

- Implementeu totes les funcions de forma senzilla, clara i concisa
  aprofitant Python.

- Descarregueu-vos el fitxer `code.py` i anomeneu-lo `recaman.py`. El
  programa principal i l'esquelet de les funcions ja se us dóna
  implementat.

- El Jutge dóna puntuacions parcials per a cada apartat i pel joc de
  proves públic, però l'avaluació va a càrrec del professor.

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-01-25T11:15:09.719Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
