# Simulating recursion (1)

In C++, consider this program (whose inclusions have been removed):

        void work(int n) {
            if (n > 0) {
                cout << ' ' << n;
                work(n - 1);
                work(n - 1);
            }
        }

        int main() {
            int n;
            while (cin >> n) {
                work(n);
                cout << endl;
            }
        }

In Python, consider this program:


    from yogi import tokens

    def work(n: int) -> None:
        if n > 0:
            print(' ', n, end='')
            work(n - 1)
            work(n - 1)

    def main() -> None:
        for n in tokens(int):
            work(n)
            print()

    main()

Take a look at the sample input and sample output to see what this
program prints for every given number.

Without modifying \@main()@, reimplement the procedure \@work(n)@ with
no calls at all, recursive or not, so that the output of the program
does not change.

## Input

Input consists of several strictly positive natural numbers.

## Output

For every number, print a line identical to the one written by the
program above.

## Observation

To solve this exercise, the only containers that you should use are
stacks.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T11:13:49.795Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
