# Double maze

Recently I discovered a fascinating solitary game at
[minijuegos.com]{.sans-serif} called Doublemaze.

The game goes as follows: Two balls (call them A and B) are located at
some cells in two independent mazes. The player's goal is to bring both
balls to their destinations cells, marked with a flag. In order to move
the balls, the player can decide to press the up, down, left or right
keys, which move both balls one position in the intended direction.
However, walls can obstruct the movement of a ball. The game ends if one
of the balls falls out of the maze (the player loses) or if both balls
reach the destination flags at the same time (the player wins and
advances to a new level).

For instance, the first level starts in the following position:

![image](doublemaze1){width="6cm"}

If we press the 'right' key, both balls move one cell to their right:

![image](doublemaze2){width="6cm"}

If we press the 'right' key again, ball A stays in the same place
because of the wall:

![image](doublemaze3){width="6cm"}

If we finally press the 'up' key, ball A also stays in the same place:

![image](doublemaze4){width="6cm"}

If now the player would press the 'right' and 'down' keys consecutively,
he or she would lose because ball B would fall out of the maze.

Please write a program to compute the minimum number of moves necessary
to solve a double maze.

## Input

Input consists of several double mazes with exactly the format shown in
the sample input. All the fields always appear in the same order.
Horizontal walls are on the top of the cells of the given coordinates.
Vertical walls are at the left of the cells of the given coordinates. At
boths mazes, the ball and the flag are at different positions, an never
on a hole. The maximum size is 30.

## Output

For every double maze, print the minimum number of movements needed to
solve the game. If there is no solution, print "`OOPS`".

## Problem information

Author: Jordi Petit

Generation: 2026-01-25T11:13:07.740Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
