# Symmetric matrix

Write a function that, given a square matrix \@m@, tells if it is
symmetric or not.

Remember that a matrix $m$ is symmetric if $m_{i,j}=m_{j,i}$ for any $i$
and for any $j$.

## Precondition

\@m@ is a square matrix $n\times n$ with $n \ge 0$.

## Interface

+-------:+:----------------------------------------------+
| C++    | ``` c++                                       |
|        | typedef vector< vector<int> > Matrix;         |
|        | ```                                           |
+--------+-----------------------------------------------+
|        | ``` c++                                       |
|        | bool is_symmetric(const Matrix& m);           |
|        | ```                                           |
+--------+-----------------------------------------------+
| Java   | ``` java                                      |
|        | public static boolean isSymmetric(int[][] m); |
|        | ```                                           |
+--------+-----------------------------------------------+
| Python | ``` python                                    |
|        | is_symmetric(m)  # returns bool               |
|        | ```                                           |
+--------+-----------------------------------------------+
| MyPy   | ``` python                                    |
|        | is_symmetric(m: list[list[int]]) -> bool      |
|        | ```                                           |
+--------+-----------------------------------------------+

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T11:09:34.820Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
