# Rastreador

Un robot rastreador es aquel que intenta seguir una línea. Uno de los
diseños más comunes consiste en tener una fila de sensores situada
delante del robot, perpendicular a la dirección de la marcha. Asumiendo
que nuestros sensores son binarios (cada sensor nos da un $0$ si no
detecta línea, y un $1$ si sí la detecta), una lectura como la siguiente

::: center
`1000111000`
:::

querría decir que disponemos de 10 sensores, y que el sensor de más a la
izquierda y tres de los sensores del medio han detectado línea.

En este problema te pedimos que programes un algoritmo sencillo de
rastreo de líneas, que a partir de las lecturas de esta fila de sensores
decida cómo debe girar el robot. En concreto, sea $x$ el primer sensor
empezando por la derecha que detecte línea, y sea $n$ el número total de
sensores (en el ejemplo anterior, $n=10$, $x=4$). Tu programa deberá
escribir un número $M$ entre el $-90$ (giro máximo a la izquierda) y el
$90$ (giro máximo a la derecha) en función de los valores de $x$ y $n$,
según la fórmula $$M = 90 - 180\frac{x-1}{n-1}.$$ En el ejemplo anterior
se tendría, pues, $M=30$. Si el valor resultante de $M$ no es entero,
redondéalo hacia el $0$.

## Entrada

En una línea, el número de casos $0\leq k\leq 1000$, seguido de $k$
líneas, cada una de las cuales contiene una lectura de la fila de
sensores. Las lecturas se te pueden pasar de dos formas distintas: en
binario, o codificadas en decimal. Una lectura en binario son siempre 10
bits ($0$ o $1$), donde siempre se cumple que el bit de más a la
izquierda tiene el valor $1$. Una lectura en decimal es un número del
$2$ al $999999999=10^9-1$ que, al ser pasado a binario (base 2), produce
la lectura de los sensores. Por ejemplo, el número decimal $214$ se
corresponde con el número binario $11010110$, puesto que
$$\begin{align*}
 214 &= 107\cdot 2 = (53\cdot 2 + 1)\cdot 2 = (26\cdot 2 +1)\cdot 2^2 + 2 =
13\cdot 2^4+2^2 + 2 = (6\cdot 2+1)\cdot 2^4+2^2+2 \\
                   &= 3\cdot 2^6+2^4+2^2+2 = (1\cdot 2+1)\cdot 2^6 +2^4 +2^2+2= 2^7 + 2^6 +2^4 + 2^2 + 2 = 11010110_b. 
\end{align*}$$

## Salida

Escribe tantas líneas como casos, con la dirección que debe seguir el
robot. En caso que la entrada sea binaria, siempre tendrás $n=10$. Si la
entrada es en decimal, debes asumir que $n$ és el mínimo número de
dígitos binarios que necesitas para representar el número dado ($n=8$ en
el ejemplo anterior).

## Puntuación

- **Test1:**

  Resolver varios casos donde todas las entradas son en binario.

<!-- -->

- **Test2:**

  Resolver varios casos de todo tipo.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T11:09:21.773Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
