# Barbarian tribes

In a lost land two primitive tribes coexist: Gareds and Kekas. Every
summer solstice they meet and compete to decide which tribe will be the
favorite of the gods for the rest of the year, following an old ritual:

First, a local guru chooses three numbers at random: $n$, $m$ and $k$.
Afterwards, $n$ Gared maids (in the positions $1, \dots, n$) and $m$
Keka maids (in the positions $n+1, \dots, n+m$) are placed in a circle
looking inwards. Then the guru begins to count $1, \dots, k$ starting at
the first Gared maid. When the $k$-th maid is reached, she is
immediately sacrificed to the gods. The guru then counts again
$1, \dots, k$ starting at the maid following the one just sacrificed.
Again, the $k$-th maid reached this way is sacrificed. After every two
sacrifices, the second sacrificed maid is replaced by a new maid. In
order to decide the tribe of the new maid, the guru looks at the heads
of the two maids just killed (nothing else remains of them). If both
heads are of the same tribe, the guru calls a Gared maid. If the heads
are from different tribes, the guru calls a Keka maid. The process then
begins again (counting and sacrificing twice and replacing once)
starting to count at the maid following the new maid just added to the
circle. Since the number of maids is reduced by one after every step (of
two sacrifices and one replacement), after $n+m-1$ steps only one maid
remains.

According to the tradition, the tribe of the last maid will be the
favorite of the gods. (What the guru does to the last maid is something
you don't want to know.) Anyway, write a program such that, given $n$,
$m$ and $k$, writes the name of the fortunate tribe.

For example, this is what happens for $n = m = 3$ and $k = 2$ (a "G"
denotes a Gared maid and a "K" denotes a Keka maid; the subindexes mark
the order the maids enter the circle):

1.  Initial content of the circle: G$_1$ G$_2$ G$_3$ K$_4$ K$_5$ K$_6$\
    Starting to count at G$_1$. First sacrifice: G$_2$. Second
    sacrifice: K$_4$ (replaced by K$_7$).

2.  Content of the circle: G$_1$ G$_3$ K$_7$ K$_5$ K$_6$\
    Starting to count at K$_5$. First sacrifice: K$_6$. Second
    sacrifice: G$_3$ (replaced by K$_8$).

3.  Content of the circle: G$_1$ K$_8$ K$_7$ K$_5$\
    Starting to count at K$_7$. First sacrifice: K$_5$. Second
    sacrifice: K$_8$ (replaced by G$_9$).

4.  Content of the circle: G$_1$ G$_9$ K$_7$\
    Starting to count at K$_7$. First sacrifice: G$_1$. Second
    sacrifice: K$_7$ (replaced by K$_{10}$).

5.  Content of the circle: G$_9$ K$_{10}$\
    Starting to count at G$_9$. First sacrifice: K$_{10}$. Second
    sacrifice: G$_9$ (replaced by K$_{11}$).

6.  Final content of the circle: K$_{11}$\

## Input

Input consists of several cases, each with three natural numbers $n$,
$m$ and $k$. You can assume $1 \le n + m \le 2000$ and
$1 \le k \le 1000$. A special case with $n = m = k = 0$ ends the input.

## Output

For every case, print either `"Gared"` or `"Keka"` as convenient.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T11:35:26.404Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
