# Artrópodos alienígenas

Un aficionado a los artrópodos (de todo hay en esta vida) tiene una
jaula con $x$ arañas y $y$ escarabajos peloteros. Al llegar la Navidad
disfraza a todos sus bichos de Papa Noel, para lo que necesita 10
gorritos y 66 calcetines. ¿Cuántos artrópodos tiene de cada tipo?

Resolver este problema es muy sencillo, si planteas bien las ecuaciones:
basta con contar cabezas (cada bicho tiene una cabeza) y contar patitas
(cada araña tiene 8, y cada escarabajo, 6). Por lo tanto,
$$\left\{ \begin{array}{l} x+y = 10 \\ 8x+6y = 66 \end{array} \right.$$
de donde se deduce que hay $x=3$ arañas y $y=7$ escarabajos.

Te pedimos que resuelvas unos cuántos problemas de este tipo con varias
especies de artrópodos alienígenas recientemente descubiertas.

## Entrada

Cada entrada consta un número indeterminado de casos de prueba. Cada
caso de prueba contiene exactamente seis números en una línea: el número
de cabezas y de patas de un artrópodo de tipo `X`, el número de cabezas
y de patas de un atrópodo de tipo `Y`, y el número de gorritos y de
calcetines que ha sido necesario comprar. Tu programa dispone de un
segundo de CPU para resolver cada entrada. Se te garantiza que ninguna
entrada tiene más de $10^5$ casos, que ningún bicho tiene 0 cabezas (o
patas) o más de $100$ cabezas (o patas), y que nunca ha sido necesario
comprar más de $10^8$ gorritos o calcetines.

## Salida

Para cada caso de pruebas, escribe en una línea el número $x$ y $y$ de
bichos de cada tipo. Se te garantiza que el resultado siempre será
entero (nunca tendrás un número fraccionario de bichos).

## Puntuación

- **easy:**

  Resolver entradas donde todos los bichos de tipo `X` son arañas, todos
  los bichos de tipo `Y` son escarabajos, y no hay más de $100$ bichos
  de cada tipo.

<!-- -->

- **hard:**

  Resolver entradas de todo tipo.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T11:27:15.681Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
