# Barcodes

Nowadays, most companies use barcodes like the following one to
distinguish their products.

![image](barres.png){width="3cm"}

The most spread code which tends to become a standard is the EAN-13.
This code is formed by 13 digits: the 12 first correspond to the code of
the product, and the last one is a digit of control. The digit of
control is a very important part of the EAN coding, because it makes
possible the elimination of the reading errors.

The digit of control is computed in two steps:

1.  We multiply by 3 the numbers which are in odd positions and we add
    up the result with the numbers which are in even position. (The
    digits are numbered from right to left.)

2.  We substract to the result the nearest equal or greater tens.

For instance, the digit of control corresponding to code 544900000099 is
computed like this:

1.  $9*3+9+0*3+0+0*3+0+0*3+0+9*3+4+4*3+5 = 84$

2.  $90-84 = 6$

Therefore, its digit of control is 6.

## Input

Input is a sequence of numbers with 12 digits each one corresponding to
different codes of products.

## Output

For each product, print in a line the original code plus its digit of
control.

## Observation

Warning: \@int@ type may not be enough to store numbers with 12 digits.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T11:26:44.820Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
