# Codis de barres

Actualment la majoria de les empreses fan servir codis de barres com el
següent per distingir els seus productes.

![image](barres.png){width="3cm"}

El codi més estès i que tendeix a convertir-se en un estàndard és
l'EAN-13. Aquest codi està format per 13 dígits: els 12 primers es
corresponen al codi del producte, i el darrer és un dígit de control. El
dígit de control és una part molt important de la codificació EAN,
perquè possibilita l'eliminació dels errors de lectura del codi.

El dígit de control es calcula en dues fases:

1.  Se sumen els dígits que ocupen una posició senar multiplicats per 3
    i els que ocupen una posició parella. (Els dígits es numeren de
    dreta a esquerra.)

2.  Es resta el resultat de la suma a la desena superior o igual més
    propera.

Per exemple, el dígit de control corresponent al codi 544900000099 es
calcula així:

1.  $9*3+9+0*3+0+0*3+0+0*3+0+9*3+4+4*3+5 = 84$

2.  $90-84 = 6$

Per tant, el seu dígit de control és el 6.

## Entrada

L'entrada és una seqüencia de nombres amb exactament 12 dígits cadascun
corresponents a diferents codis de productes.

## Entrada

Per a cada producte, cal escriure en una línia el codi original
augmentat del dígit de control EAN-13.

## Observació

Compte: El tipus \@int@ pot no ésser suficient per guardar nombres de 12
dígits!

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-01-25T11:26:40.479Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
