# El petit teorema de Fermat

Sigui $C = \{c_0, \ldots, c_{a - 1}\}$ un conjunt amb $a$ colors
diferents. Heu de dissenyar collarets amb $p$ vidres, cadascun amb un
color de $C$, i usant almenys dos colors. Però, tenint en compte que els
collarets són cíclics, per evitar dissenys repetits heu de generar només
els que siguin més petits lexicogràficament. Per exemple,
`(Green, Green, Blue)` és cíclicament equivalent a
`(Green, Blue, Green)`, i a `(Blue, Green, Green)`. D'aquests tres
dissenys, cal generar només l'últim, perquè és el més petit en ordre
lexicogràfic.

A partir d'ara, suposem que $p$ és un nombre primer. En aquest cas, es
pot demostrar que hi ha exactament $\frac{a^p - a}{p}$ dissenys
diferents. Fixeu-vos que això implica que $a^p - a$ és múltiple del
primer $p$. Això és precisament el que diu el petit teorema de Fermat,
el qual, malgrat el nom, és un dels teoremes més importants de les
matemàtiques!

## Entrada

L'entrada comença amb tres enters $d$ (senar), $p$ (primer) i $a$, amb
$d \ge 5$, $2 \le p \le 13$, i $2 \le a \le 100$, seguit d'$a$ colors
diferents en ordre alfabètic, tot en línies diferents.

## Sortida

Genereu una imatge de dimensions
$\left(d \cdot p, d \cdot \frac{a^p - a}{p} \right)$ amb fons '`Black`',
consistent en $\frac{a^p - a}{p}$ columnes. Cadascuna té un disseny amb
$p$ cercles de diàmetre $d$. Els dissenys han de sortir ordenats
lexicogràficament d'esquerra a dreta. Cap imatge tindrà més de $10^6$
píxels.

## Informació del problema

Autoria: Félix Moreno

Generació: 2026-01-25T11:25:09.234Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
