# Distància Manhattan

Sigui $\mbox{abs}(z)$ el valor absolut de $z$. Per exemple,
$\mbox{abs}(7) = \mbox{abs}(-7) = 7$.

Donats dos punts en el pla $(x_1, y_1)$ i $(x_2, y_2)$, la seva
distància Manhattan es defineix com
$\mbox{abs}(x_1 - x_2) + \mbox{abs}(y_1 - y_2)$.

Feu un programa que lleigeixi vuit naturals $n$, $m$, $x_r$, $y_r$,
$x_g$, $y_g$, $x_b$ i $y_b$, i que dibuixi una imatge amb $n \times m$
punts. El component *red* del color de cada punt $(x, y)$ ha de ser el
residu de la divisió entre 256 de la distància Manhattan entre $(x, y)$
i $(x_r, y_r)$, i similarment amb els components *green* i *blue*
respecte de $(x_g, y_g)$ i $(x_b, y_b)$, respectivament.

## Entrada

L'entrada consisteix en els vuit naturals mencionats anteriorment. Podeu
suposar que les tres $x$ estan entre 0 i $n - 1$, i que les tres $y$
estan entre 0 i $m - 1$. Però pot ser que algun component del color no
s'hagi d'usar (és a dir, que hagi de ser 0 a tot arreu). Això s'indica
amb un parell de -1 per a aquell component.

## Sortida

Cal generar una imatge $(n, m)$ segons s'ha explicat.

## Observació

En Python 3, la funció valor absolut es diu $\mbox{abs}()$, i el residu
es calcula amb l'operador %.

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T11:22:57.121Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
