# Adding fingers

Consider a game for two players playing alternatively. Both players show
a certain number of fingers in each hand. Let X be the player that moves
next, and let Y be the other player. Let $a$ and $b$ be the number of
fingers shown by X, and let $c$ and $d$ be the number of fingers shown
by Y. In each turn, these are the allowed moves:

1.  Add $\bmod$ 5 as many fingers as X has in a non-empty hand (a hand
    showing at least one finger) to one of Y's non-empty hands. That is:
    $$\left\{\begin{array}{cc}
            (a,b)(c,d) \to (a,b)(c+a,d) & \text{if } a,c \neq 0 \\
            (a,b)(c,d) \to (a,b)(c,d+a) & \text{if } a,d \neq 0 \\
            (a,b)(c,d) \to (a,b)(c+b,d) & \text{if } b,c \neq 0 \\
            (a,b)(c,d) \to (a,b)(c,d+b) & \text{if } b,d \neq 0
            \end{array}\right.$$

2.  "Move" the fingers in one of X's hands to the other hand, provided
    that none of them are empty. Again, the operations are made $\bmod$
    5: $$\left\{\begin{array}{lr}
        (a,b)(c,d) \to (a+b,0)(c,d) & \text{if } a,b \neq 0 \\
        (a,b)(c,d) \to (0,a+b)(c,d) & \text{if } a,b \neq 0
        \end{array}\right.$$

3.  "Redistribute" the fingers in X's hands, if one of them is empty:
    $$\left\{\begin{array}{lr}
            (a,0)(c,d) \to (x,y)(c,d) & \text{if } x+y=a \text{ and } 0 < x,y < a \\
            (0,b)(c,d) \to (x,y)(c,d) & \text{if } x+y=b \text{ and } 0 < x,y < b
            \end{array}\right.$$

Both players play perfectly. The first player to get to $(0, 0)$ loses
the game. A game that never ends is considered to be a draw.

## Input

Input consists of several cases, each one with $a$, $b$, $c$ and $d$,
all between 0 and 4. Assume $a + b > 0$ and $c + d > 0$.

## Output

For every case, tell if X will win, if X will lose, or if the game is a
draw.

## Problem information

Author: Marc Felipe

Generation: 2026-01-25T11:19:59.298Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
