# Código César

El código César es un método antiguo (y no particularmente seguro) de
cifrado. En este problema consideramos la siguiente variante: Dado un
texto en castellano, con un léxico más o menos usual, primero eliminamos
todas las tildes, y cambiamos todas las '`ñ`' por '`n`'. Después,
convertimos las letras minúsculas a mayúsculas. A continuación,
eliminamos cualquier carácter que no sea una letra, un salto de línea,
un espacio, o cualquiera de los caracteres siguientes:

                        -  .  ,  ;  :  ?  !  (  )

Finalmente, escogemos al azar un número $k$ entre 1 y 25, y
transformamos cada letra $\ell$ en $\ell + k$, cíclicamente. Por
ejemplo, con $k = 2$, '`A`' pasaría a ser '`C`', '`B`' pasaría a ser
'`D`', ..., '`X`' pasaría a ser '`Z`', '`Y`' pasaría a ser '`A`', y
'`Z`' pasaría a ser '`B`'.

¿Podéis descifrar un texto dado?

## Entrada

La entrada consiste en el resultado de cifrar un texto como se ha
explicado anteriormente. El texto proporcionado tiene entre 300 y 3000
caracteres. No hay líneas vacías, y cada línia no tiene más de 80
caracteres.

## Salida

Escribid el texto una vez descifrado.

### Puntuación

Hay 10 juegos de pruebas privados, todos diferentes al ejemplo, y cada
uno vale 10 puntos.

## Observación

Aunque no se podrá controlar de manera automàtica, para este problema
sólo se evaluará el mejor de los 10 primeros envíos de cada
participante. Los demás, si existen, se eliminarán después de la prueba.

## Pista

Recordad que este código

        string s;
        while (getline(cin, s)) {
            ...
        }

permite leer todas las líneas de la entrada hasta su final, almacenando
cada vez una línea completa en el string `s`.

## Información del problema

Autoría: Salvador Roura

Generación: 2026-01-25T11:19:01.154Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
