# F003A. Pentadiagonal matrices

A square matrix is called *pentadiagonal* if all the elements out of the
main diagonal and of the two diagonals over and under the main diagonal
are 0.

For instance, the matrix on the left is pentadiagonal, but, the matrix
on the right is not (it would be pentadiagonal if the 9 on the second
and the sixth row were 0).

::: center
2  0  1  0  0  0  0  0  0  0   6  7  0  0  0  0  0  0  0\
9  4  1  1  0  0  0  0  0  0   7  3  6  0  0  0  9  0  0\
1  1  5  1  5  0  0  0  0  0   7  0  7  3  0  0  0  0  0\
0  6  3  2  5  1  0  0  0  0   8  7  8  1  4  0  0  0  0\
0  0  2  1  5  1  1  0  0  0   0  8  2  1  4  1  0  0  0\
0  0  0  1  9  0  9  9  0  0   0  9  5  1  4  1  1  0  0\
0  0  0  0  5  1  1  1  8  0   0  0  0  1  4  4  5  6  0\
0  0  0  0  0  5  1  5  2  4   0  0  0  0  6  8  7  7  2\
0  0  0  0  0  0  4  5  4  4   0  0  0  0  0  8  4  0  0\
0  0  0  0  0  0  0  5  5  7   0  0  0  0  0  0  7  5  5\
:::

Using the definition

        typedef vector<vector<int> > Matrix;

Implement the function

        bool is_pentadiagonal(const Matrix& mat);

that prints whether \|mat\| is pentadiagonal or it is not.

Also, using the definition

        struct Info {
            int sum;
            int max;
        };

Implement the procedure

        void calculate(const Matrix& mat, Info& inf);

that stores in the fields \|sum\| and \|max\| of the output parameter
\|inf\| the sum and the maximum of *all* the \|mat\| elements, under the
precondition that \|mat\| is pentadiagonal.

The main program is already done; do not modify it. It reads square
matrices of integers, and for each one, if the matrix is pentadiagonal,
writes the sum and the maximum of its elements; Otherwise, it prints
that the matrix is not pentadiagonal.

## Precondition

The matrices \|mat\| are $n\times n$ with $n\ge6$.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T18:11:15.494Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
