# P0016. Maya numbers

The Mayas were people that lived mainly in the south of the place that
today is Mexico and in Central America, establishing one of the most
important mesoamerican cultures before the arrival of the Spaniards. The
Mayas developed the concept of zero, and their sophisticated mathematics
used a vigesimal system of numeration (that is, in base 20).

The numerals were formed by three symbols; the zero (with form of
shell), the one (with form of point) and the five (with form of
horizontal bar). For instance, number thirteen was written with three
points disposed horizontally above of two bars, one over the other one.
The following figure shows how the numbers from zero to nineteen were
represented:

![image](digits.png){width="4cm"}

The numbers after the nineteenth were written vertically towards up in
powers of twenty. For instance, the thirty-three was written like twenty
over thirteen, that is, a point (twenty) over three points (three) over
two bars (ten). Thus, $33 = 1 \cdot 20^1 + 13 \cdot 20^0
= 1 \cdot 20 + (3 + 2 \cdot 5)$. On arriving at 400, another power of
twenty was used. The Mayas wrote then 649 like a point over two points
over two bars over four points over one bar, since
$649 = 1 \cdot 20^2 + 12 \cdot 20^1 + 9 \cdot
20^0 = 1 \cdot 400 + (2 + 2 \cdot 5) \cdot 20 + (4 + 1 \cdot 5)$.

The following picture shows an engraving of the 2nd century found at La
Mojarra, near Veracruz. The first column contains the number 1326589,
corresponding to $8\cdot20^4+5\cdot20^3+16\cdot20^2+9\cdot20+9$.

![image](pedra.png){width="3cm"}

Your task is to write a program that reads numbers and prints them using
the maya system.

## Input

The input is a sequence of natural numbers.

## Output

Your program must print each natural number of the sequence in decimal
and in the maya system, following the instances of the format. The shell
is that represents 0 must be written as a "\|zero\|". A horitzontal bar
is formed by five dashes (no underlines).

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T11:17:34.726Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
