# Game of Nim for three players

Consider this variant of the game of Nim for three players: There are
several heaps of stones. By turns, the current player must remove at
least one stone from one of the heaps. The player that cannot play loses
the game, and the other two players win.

Given a position, described with the number of stones of each heap, can
you tell the outcome of the game? Assume that the three players take
decisions rationally.

For instance, consider the position $\{1, 2\}$. Removing 1 from 2, going
to $\{1, 1\}$, would be suicidal, because the current player would lose
after two more turns. Removing 1 from 1, going to $\{2\}$, would be a
better choice, because the next player could decide to remove 1 or 2
stones (he would win anyway), and therefore the current player could
eventually win. However, removing 2 from 2, going to $\{1\}$, would
guarantee a win. As a conclusion, $\{1, 2\}$ is winning for the first
and the second player, and losing for the third player.

Let us now consider $\{2, 2\}$. Removing 1 from one 2, going to
$\{1, 2\}$, would be a bad decision, because we already know that
$\{1, 2\}$ is losing for the third player to play. By contrast, removing
one 2, going to $\{2\}$, gives the current player some hope, depending
on the decision of the second player, who will definitely win.

## Input

Input consists of several positions, each with the number of heaps $n$,
followed by the number of stones of each heap. No heap is empty, and the
total sum of stones is at most 30.

## Output

For each given position, print three characters with the result of the
game. For each player, in order of play, print a '`W`' if he will surely
win, print an '`L`' if he will surely lose, or print a '`D`' if he could
win or lose.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T11:17:10.582Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
