# Salta-salta

Se tiene un tablero de juego, formado por $n$ casillas numeradas del $0$
al $n-1$, de forma *circular*, como se muestra en la figura siguiente
(con $n=8$):

:::: center
::: NoShortVerb
       2   1   2   1   1   2  
  --- --- --- --- --- --- --- ---
   0   1   2   3   4   5   6   7
:::
::::

Los números pequeños son el *índice* de la casilla (de $0$ a $n-1$), el
número grande es el *valor* de la casilla. La doble flecha indica que el
tablero es *circular*: si estás en la casilla $n-1$ (en el ejemplo, la
$7$) y avanzas una casilla, caes a la casilla $0$; y si estás en la
casilla $0$ y retrocedes una casilla, caes a la casilla $n-1$.

Se tiene una ficha que empieza en la casilla $0$. A cada turno, la
casilla mira el *valor* de la casilla, y avanza (o retrocede, si el
número es negativo) tantas casillas como indica dicho número.

Haz un programa que descubra dónde acabará una ficha después de avanzar
$t$ turnos.

## Entrada

Cada entrada contiene un único caso de pruebas. Primero, se dan los
números $n>2$ y $t\geq 0$ en una línea, separados por espacios. A
continuación, y también separados por espacios, una línea con los $n$
valores enteros que contienen las casillas $0$, $1$, ..., $n-1$.

## Salida

Escribe una línea con el índice (de $0$ a $n-1$) de la casilla donde
estará la ficha después de avanzar $t$ turnos de juego.

## Puntuación

Hay 10 grupos de entradas. Tu programa recibirá 10 puntos por cada grupo
de entradas resuelto correctamente, en menos de 1 segundo de CPU por
entrada. Ninguna entrada contendrá una $t$ mayor que $10000$. Las
entradas del grupo $i$-ésimo no tendrán $n$ superiores a $3, 5, 10,
20, 50, 100, 200, 500, 1000, 5000$. Además, los valores de las casillas
de los 3 primeros grupos de entradas únicamente serán $1$ o $2$; en los
siguientes $3$ grupos únicamente aparecerán valores entre $-1000$ y
$1000$; y en las casillas de los restantes $4$ grupos aparecerán valores
entre $-10^9$ y $10^9$.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T11:15:43.445Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
