# Recursive sandwiches

Nowadays there are sandwiches of almost any ingredient. A crazy chef has
just discovered recursion, so he is considering making sandwiches of
sandwiches (of sandwiches \...). Since thinking in three dimensions is
somehow difficult, he first wants to study the following two-dimensional
model for making rectangular sandwiches.

Square pieces, with height 1 and length 1, correspond to ingredients;
rectangular pieces, with height 1 and length $\ell$ (for any natural
number $\ell \ge 2$), correspond to slices of bread. Then, a recursive
sandwich (RS) is defined by these rules:

1.  Any single ingredient is a RS.

2.  Let $h \ge 1$, $\ell \ge 2$, and let $S$ be any sequence
    $R_1, \dots, R_n$ of RS's where $n \ge 2$, and such that
    $\mbox{height}(R_i) = h$ for every $1 \le i \le n$, and
    $\sum_{i=1}^n \mbox{length}(R_i) = \ell$. Then

    1.  The result of placing a $1 \times \ell$ slice at the bottom of
        $S$ is a RS.

    2.  The result of placing a $1 \times \ell$ slice at the top of $S$
        and another $1 \times \ell$ slice at the bottom of $S$ is a RS.

3.  There are no RSs other than those constructable from rules 1, 2(a)
    and 2(b).

These are some examples of recursive sandwiches:

![image](valid){height="2.5cm"}

And these are some examples of wrong sandwiches:

![image](invalid){height="2.5cm"}

Write a program to tell if some given sandwiches follow the rules of the
crazy chef or not.

## Input

Input consists of several cases. Every case begins with the name of the
sandwich, followed by its height $H$, its length $L$, and its number of
pieces $m$. Then follow $m$ triples of integer numbers $r$, $c$ and
$\ell$ describing every piece: $(r, c)$ is the position of the left
square of the piece; $\ell$ is the length of the piece. Assume
$1 \le H \le 20$ and $1 \le L \le 100$. The lower-left position of a
sandwich is $(1, 1)$. The sum of the areas of the pieces is exactly
$H \times L$, and every position in $[1,H] \times [1,L]$ is covered by a
piece.

(The sandwich `aaa` in the sample input is the second of the recursive
sandwiches given as example. The sandwich `bbb` is the fourth of the
wrong sandwiches.)

## Output

For every given sandwich, tell if it is a recursive sandwich or not.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T11:15:15.151Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
