# Personajes de RPG

En este problema, al igual que en el problema "Dados Raros", necesitarás
números pseudo-aleatorios. Para generarlos, usa la misma fórmula
$$y_n = (75\cdot y_{n-1}) \ \text{mod } 65537.$$ Simularemos el
lanzamiento de un dado de $N$ caras (con caras del $1$ al $N$) mediante
la fórmula $(y \% N) +1$, donde $y$ es el número pseudo-aleatorio.

Se te pide que generes personajes al azar para un juego de rol. Cada
personaje pertenece a una *raza*, y cada raza tiene unos *atributos*
propios. La puntuación de un personaje en cada atributo depende de una
tirada de dados, que designamos mediante un *código* como los
siguientes:

::: center
$X$`d`$Y$+$B$, $\qquad\qquad$ $X$`d`$Y$, $\qquad\qquad$ $X$`d`$Y$-$B$,
:::

donde $X$ es el número de dados que hay que tirar (de 1 a 9), $Y$ es el
número de caras que tiene el dado (siempre será $4$, $6$, $8$, $10$,
$12$ o $20$), y $B$ es un número positivo (de 1 a 9). Por ejemplo, los
códigos $4$`d`$6$, $2$`d`$4-2$ y $1$`d`$20+5$ indican que la puntuación
del atributo se obtiene, respectivamente, sumando los lanzamientos de 4
dados de 6 caras; sumando 2 dados de 4 caras y restando 2 al resultado;
y sumando 5 a un dado de 20 caras. Ningún atributo debe ser 0 o
negativo: si el resultado final de un cálculo así lo fuera, la
puntuación final del atributo sería 1.

## Entrada

Consulta los ejemplos de prueba para entender mejor el formato de la
entrada. La primera línea contiene la semilla $y_0$ de los números
pseudo-aleatorios que se usarán para generar todas las tiradas. A
continuación, un número indeterminado de líneas (pero inferior a 10000).
Las líneas son de dos tipos, líneas de raza (`R`) o líneas de personaje
(`P`).

Las líneas de raza siguen el formato

::: center
`R [raza] `$k$` [atr1] [`$X$`d`$Y\!\pm\!B$`] ... [atr`$k$`] [`$X$`d`$Y\!\pm\!B$`]`
:::

donde `[`raza\] es el nombre de una raza (sin espacios) con $0<k\leq 10$
atributos, de nombres `[atr1]`,...,`[atr`$k$`]` y con sus
correspondientes códigos `[`$X$`d`$Y\!\pm\!B$`]`. No habrá dos razas, ni
dos atributos dentro de la misma raza, con idéntico nombre; ningún
nombre de raza o atributo tendrá más de 10 caracteres.

Las líneas de personaje siguen el formato

::: center
`P [raza] `$n$
:::

para indicar que generes $n$ personajes de la raza `[raza]`.

## Salida

La salida de tu programa deberá contener una línea por cada personaje
que generes. Esta línea empezará con el texto `[raza] #`$i$`:` , donde
`[raza]` es la raza del personaje, y $i$ es el número de personaje que
generas de dicha raza. A continuación, y separados por espacios, los
nombres de los $k$ atributos y las puntuaciones que se obtienen para
dicho personaje al lanzar los dados. Escribe los atributos en el mismo
orden en el que te los dieron, y acaba cada línea con un punto.

Procesa la entrada en el orden en el que se te da. Si se te pide generar
personajes de una raza que no existe (o que todavía no ha sido descrita)
escribe una línea con el texto "`Raza xxxx no existe.`".

## Puntuación

## Puntuación

Test140 Resuelve juegos de prueba (como el Ejemplo 1) donde todos los
códigos de lanzamiento de dados son de la forma $x$`D`6, todas las razas
existen, y no hay más de 50 líneas.

- **Test2:**   Resuelve juegos de prueba de todo tipo.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T11:14:31.102Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
