#include <typeinfo>
#include <iostream>
using namespace std;


Rational sum(const Rational& a, const Rational& b);
Rational substraction(const Rational& a, const Rational& b);
Rational product(const Rational& a, const Rational& b);
Rational division(const Rational& a, const Rational& b);
void adds_one(Rational& r);

int __mcd(int a, int b) {
    if (b == 0) return a;
    return __mcd(b, a%b);
}

Rational __racional(int n, int d) {
    Rational r;
    if (n == 0) {
        r.num = 0;
        r.den = 1;
    }
    else {
        int sig;
        if ((n > 0 and d > 0) or (n < 0 and d < 0)) sig = 1;
        else sig = -1;

        if (d < 0) {
            n = -n;
            d = -d;
        }

        int m = __mcd(sig*n, d);
        r.num = n/m;
        r.den = d/m;
    }
    return r;
}



void __read_racional(Rational& r, bool& end) {
    int num, den;
    end = not (cin >> num >> den);
    if (not end) r = __racional(num, den);
}


void __print_racional(const Rational& r) {
    cout << r.num;
    if (r.den > 1) cout << "/" << r.den;
}


int main() {

  { // Vigilem el tipus Racional.

    struct Racional_control {
      int num, den;
    };

    Rational r;
    Racional_control rc;

    // Diagn�stics en temps de compilaci�.
    r.num = rc.num;
    r.den = rc.den;

    // Diagn�stics en temps d'execuci�.
    if (sizeof(r) != sizeof(rc)) throw string("It seems that 'Rational' is not well defined");
    if (typeid(r.num) != typeid(rc.num)) throw string("It seems that 'Rational.num' is not well defined");
    if (typeid(r.den) != typeid(rc.den)) throw string("It seems that 'Rational.den' is not well defined");
  }

  int n;
  cin >> n;
  while (n--) {
    Rational a, b;
    bool aux;
    __read_racional(a, aux);
    __read_racional(b, aux);
    __print_racional(sum(a, b));
    cout << endl;
    __print_racional(substraction(a, b));
    cout << endl;
    __print_racional(product(a, b));
    cout << endl;
    if (b.num != 0) {
      __print_racional(division(a, b));
      cout << endl;
    }
    adds_one(a);
    __print_racional(a);
    cout << endl;
  }
  return 0;
}
