#include <typeinfo>
#include <iostream>
using namespace std;


Racional suma(const Racional& a, const Racional& b);
Racional resta(const Racional& a, const Racional& b);
Racional producte(const Racional& a, const Racional& b);
Racional divisio(const Racional& a, const Racional& b);
void suma_un(Racional& r);

int __mcd(int a, int b) {
    if (b == 0) return a;
    return __mcd(b, a%b);
}

Racional __racional(int n, int d) {
    Racional r;
    if (n == 0) {
        r.num = 0;
        r.den = 1;
    }
    else {
        int sig;
        if ((n > 0 and d > 0) or (n < 0 and d < 0)) sig = 1;
        else sig = -1;

        if (d < 0) {
            n = -n;
            d = -d;
        }

        int m = __mcd(sig*n, d);
        r.num = n/m;
        r.den = d/m;
    }
    return r;
}



void __llegeix_racional(Racional& r, bool& final) {
    int num, den;
    final = not (cin >> num >> den);
    if (not final) r = __racional(num, den);
}


void __escriu_racional(const Racional& r) {
    cout << r.num;
    if (r.den > 1) cout << "/" << r.den;
}


int main() {

  { // Vigilem el tipus Racional.

    struct Racional_control {
      int num, den;
    };

    Racional r;
    Racional_control rc;

    // Diagnstics en temps de compilaci.
    r.num = rc.num;
    r.den = rc.den;

    // Diagnstics en temps d'execuci.
    if (sizeof(r) != sizeof(rc)) throw string("Sembla que 'Racional' no est ben definit");
    if (typeid(r.num) != typeid(rc.num)) throw string("Sembla que 'Racional.num' no est ben definit");
    if (typeid(r.den) != typeid(rc.den)) throw string("Sembla que 'Racional.den' no est ben definit");
  }

  int n;
  cin >> n;
  while (n--) {
    Racional a, b;
    bool aux;
    __llegeix_racional(a, aux);
    __llegeix_racional(b, aux);
    __escriu_racional(suma(a, b));
    cout << endl;
    __escriu_racional(resta(a, b));
    cout << endl;
    __escriu_racional(producte(a, b));
    cout << endl;
    if (b.num != 0) {
      __escriu_racional(divisio(a, b));
      cout << endl;
    }
    suma_un(a);
    __escriu_racional(a);
    cout << endl;
  }
  return 0;
}
