# Pig Latin

Pig Latin is a pseudo-language that can be used to disguise what is
really said. Here, we will codify words made up of only lowercase
letters with one of the variants of Pig Latin.

The codification of a word depends on the position of its first vowel.
As usual, we consider as vowels '`a`', '`e`', '`i`', '`o`' and '`u`'. If
the word does not have any vowel (nor any '`y`' that acts as a vowel,
see below), its codification is the word itself. For instance, "`pdf`"
produces "`pdf`".

If the word begins with a vowel, we just add "`yay`" to the end of the
word. For instance, "`egg`" produces "`eggyay`", and "`i`" produces
"`iyay`".

If the word begins with one or more consonants, we move all the
consonants to the left of the first vowel to the end of the word, and we
add "`ay`" to the end of the result. For instance, "`hello`" produces
"`ellohay`", and "`switch`" produces "`itchsway`".

For the letter '`y`' we have a special rule: if the word has at least a
'`y`' such that

- it is not at the beginning of the word, and

- it does not have any vowel to its left,

then we treat the first such '`y`' as a vowel. For instance, "`my`"
produces "`ymay`", "`rhythm`" produces "`ythmrhay`", and "`flyaway`"
produces "`yawayflay`".

Note that a '`y`' starting a word acts as a consonant. For instance,
"`yoyo`" produces "`oyoyay`", "`yellow`" produces "`ellowyay`",
"`ypsiliform`" produces "`iliformypsay`", and "`yxzyyu`" produces
"`yyuyxzay`" (in this last example, the second '`y`' acts as a vowel).

Given a sequence of words, can you codify them?

## Input

Input consists of several cases. Each case consist in a line with
between 1 and 100 words separated by spaces and ended with the special
word "`.`". All words will have between 1 and 10 lowercase letters, and
may not exist in any language.

## Output

Print each given line after codifying it with the Pig Latin variant
presented here.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T11:04:41.753Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
