# Arbres Fractals

Voleu pintar en Python arbres fractals tant xulos com aquest?

::: center
![image](10.pdf){height="5cm"}
:::

Per pintar un arbre de $n\ge1$ nivells de mida $d$, cal pintar el seu
tronc de mida $d$, la seva branca esquerra i la seva branca dreta,
ambdues com a arbres de $n-1$ nivells i mida $\frac34 d$, i simètriques
respecte del tronc amb un angle de $2\alpha$ graus entre elles. Un arbre
de zero nivells és buit.

Per exemple, aquests són els arbres (de mida 100) amb 1, 2, 3, 4, 5 i 6
nivells quan $\alpha=30$:

::: center
1      

4      
:::

## Entrada

A l'entrada, es dónen tres valors: un natural $n$ amb el nombre de
nivells de l'arbre, un real positiu $d$ amb la seva mida, i un real
$\alpha$ amb l'angle (en graus) entre les seves branques.

## Sortida

El programa ha de dibuixar un arbre d'$n$ nivells, mida $d$ i angle
$\alpha$.

::: multicols
2

## Exemple d'entrada 1

    4
    100
    30

## Exemple de sortida 1

![image](4.pdf){height="3.5cm"}
:::

::: multicols
2

## Exemple d'entrada 2

    5
    200
    90

## Exemple de sortida 2

![image](sample2.pdf){height="3.5cm"}
:::

## Recordatori

Recordeu que Python ofereix un mòdul `turtle` que permet pintar images
amb una tortuga que es desplaça. Les úniques operacions que us calen són
`turtle.forward(d)` que avança la tortuga `d` unitats,
`turtle.backward(d)` que recula la tortuga `d` unitats,
`turtle.right(a)` que gira la tortuga `a` graus a la dreta i
`turtle.left(a)` que gira la tortuga `a` graus a l'esquerra.

Per exemple, aquest programa pinta un aborrit quadrat:

::: small
    import turtle
    import jutge

    d = jutge.read(float)
    for i in range(4):
        turtle.forward(d)
        turtle.right(90)
:::

## Important

Aquest problema no té jocs de proves al Jutge. Per tant, qualsevol
solució serà acceptada: semàfor verd! Això no vol dir que sigui bona ni
dolenta, el vostre professor ho corregirà.

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-02-04T19:36:13.371Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
