# Numerology

![image](damien.jpg){width="5cm"}

According to the Bible, 666 is the "number of the beast". Indeed, in
Revelation $\mit 13$:$\mit 18$ it is said:

> "*...count the number of the beast: for it is the\
> number of a man; and his number is 666.*"

Many theologists have associated 666 with the Antichrist. Believe it or
not, 666 has many interesting numerological properties. For instance,
$$\begin{align*}
666 \enspace &= \enspace 3^6 - 2^6 + 1^6 \\
    \enspace &= \enspace 1 + 2 + 3 + \cdots + 6 \cdot 6 \\
    \enspace &= \enspace 2^2 + 3^2 + 5^2 + 7^2 + 11^2 + 13^2 + 17^2 .
\end{align*}$$

Another curious property is that it is possible (there are exactly two
ways) to insert '`+`' signs into the number 123456789 to get 666:
$$666 \enspace = \enspace 1 + 2 + 3 + 4 + 567 + 89
 \enspace = \enspace 123 + 456 + 78 + 9 ,$$ and it is also possible
(there is exactly one way) to do the same with the number 987654321:
$$666 \enspace = \enspace 9 + 87 + 6 + 543 + 21 .$$

Let's play numerology. Write a program such that, given two numbers $n$
and $m$, prints all the ways to insert '`+`' signs into $m$ so that the
sum is $n$.

## Input

Input consists of several cases. Every case has two strictly positive
natural numbers $n$ and $m$, each not larger than $10^{12}$. Assume that
the leftmost digit of $n$ and of $m$ is never zero.

## Output

For every case, print all the ways to get $n$ by adding the digits of
$m$ as explained above. The solutions must appear in lexicographical
order. If no solution exists, state so.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T11:01:32.761Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
