# Tragaperras (Interactivo)

ESTE PROBLEMA NO FUNCIONA AUN.

Te ha tocado el premio de la fiesta mayor de tu pueblo: ¡te invitan a
jugar nada más y nada menos que $1000$ partidas por día, durante $d=50$
días, en las $n=10$ máquinas tragaperras de la casa parroquial! Las
partidas ya están pagadas, y tú te quedarás con todos los premios que
consigas. Como jugar a las máquinas tragaperras es lo más aburrido del
mundo, te pedimos que hagas un programa que haga las 50000 apuestas en
tu lugar.

*A diferencia de la mayoría de los problemas de la OIE, donde tu
programa debe calcular la salida correcta a una entrada dada, este
problema es *interactivo*: la entrada que reciba tu programa cambiará en
función de lo que responda. **Además, no está permitido hacer más de 10
envíos, correctos o incorrectos: los envios posteriores al décimo no
contabilizarán para la clasificación.***

Pero hay más: algunas de las máquinas de la casa parroquial están
programadas para repartir más premios que otras (¡de hecho, en una de
ellas es más fácil ganar dinero que perderlo!). Todas las máquinas
reparten tres tipos de premio: `x1`, `x2` y `x5`, y tus "informadores"
te han pasado información de la frecuencia con la que las 10 máquinas
reparten premios. La columna *promedio* indica el número de monedas que,
en promedio, tu programa recuperará por cada moneda apostada.

:::: center
::: NoShortVerb
  `x1`   `x2`   `x5`    Promedio
  ------ ------ ------ ----------
  20%    20%    10%      $1.1$
  15%    30%    5%       $1.0$
  20%    10%    10%      $0.9$
  20%    5%     10%      $0.8$
  15%    20%    5%       $0.8$
  30%    20%    2%       $0.8$
  15%    10%    5%       $0.6$
  30%    10%    2%       $0.6$
  20%    5%     5%       $0.55$
  20%    10%    2%       $0.5$
:::
::::

Desgraciadamente, al inicio de cada día un operario intercambia las
máquinas de lugar al azar, por lo que la mejor máquina de hoy puede ser
la peor el día siguiente. ¿Eres capaz de hacer un programa que, para
cada uno de los $d=50$ días, descubra dónde están las mejores máquinas
y, por consiguiente, obtenga el mayor número de ganancias?

### Entrada/Sortida

La entrada empieza con una línea con la palabra `EMPIEZA` y los números
$n=10$, $p=1000$ y $d=50$ (número de máquinas, número de partidas por
día y número de días). Para apostar, deberás escribir una línea (acabada
en salto de línea) con el número de máquina, entre 1 y $10$, en el que
quieres apostar. A continuación, lee una línea de texto de la entrada,
que contendrá `--` (si pierdes), `x1`, `x2` o `x5` si ganas. Cada $p$
partidas jugadas las máquinas se reasignarán aleatoriamente (sin que tu
programa reciba ninguna línea de texto adicional avisando del camio). Tu
programa debe acabar después de jugar las $p\cdot d =
50000$ apuestas.

A continuación mostramos un posible ejemplo de entrada/salida (en este
ejemplo cambiamos los valores de $n$, $p$ y $d$).

`> EMPIEZA 10 5 2`\
`< 1`\
`> x1`\
`< 1`\
`> x2`\
`< 1`\
`> x2`\
`< 2`\
`> --`\
`< 2`\
`> --`\
`< 1`      (primera jugada del segundo día)\
`> --`\
`< 1`\
`> --`\
`< 2`\
`> x1`\
`< 2`\
`> x2`\
`< 2`\
`> x2 FIN`\
`< FINAL 1.1 0.85 1.0`\

La última línea (`FINAL 1.1 0.85 1.0`) contiene información que tu
programa no necesita: el promedio de ganancias de la mejor máquina, el
promedio de todos los promedios de las máquinas, y el promedio de
ganancias que tu programa ha realizado. Tu programa será puntuado en
función de esta información.

Para poder probar que tu programa funciona correctamente antes de
enviarlo al juez on-line, puedes usar el archivo que acompaña a este
enunciado en la web de la Olimpiada Informática. Después de descargar y
descomprimir tal archivo, podrás usar el comando

`./tragaperras.exe entrada.txt`

para experimentar por tu mismo la entrada y la salida, y el comando

`python conn.py ./programa.exe entrada-juez.txt`

para probar tu programa `./programa.exe` contra un ejemplo de entrada
`entrada-juez.txt`. Encontrarás varios ejemplos de entradas, incluyendo
un `entrada-juez.txt` que será semejante al que usará el juez para
puntuar tu programa (el juez on-line usará las mismas máquinas
tragaperras, pero con distinta ordenación a lo largo de los días.)

### Puntuación

Un programa correcto se valorará entre $10$ y $100$ puntos en función de
las ganancias que obtenga: $10$ si es igual o inferior a lo que se
esperaría que obtuviese jugando al azar (38250), y entre $10$ y $100$
puntos en función de lo que se acerque al máximo esperado de ganancias
(55000).

En este problema no es posible alcanzar la puntuación máxima, $100$
puntos, que indicaría que el programa siempre sabe cuál es la mejor
máquina.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T11:27:06.917Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
