#  Pizzanomicón 

Algunos pocos fragmentos del libro de cocina más importante de todos los
tiempos, el Pizzanomicón.

"Cuatro son los pilares en los que se fundamenta una buena pizza: la
honradez de la masa, la calidad de la mozzarela, la valentía de los
ingredientes, y la sabiduría del horno."

"Compra la masa de pan cruda en una panadería, dale tú mismo la sagrada
forma de disco. Usa un poco de harina para evitar que se enganche.
Obtendrás una masa buena y muy, muy barata. Recuerda que comer masa de
pizza congelada es pecado."

"No ahorres dinero en la mozzarela, tanto si usas mozzarela para fundir,
como si optas por mozzarela *di bufala*. Usar mozzarela barata es
pecado."

"Usa aquellos ingredientes que se puedan comer crudos (anchoas,
embutidos, piña\...) o aquellos que, cortándolos finos, necesiten muy
poca cocción (champiñones, bacon\...). Es pecado usar champiñones en
conserva, pudiéndolos comprar frescos."

"Pon el horno a máxima potencia. Conoce tu horno: según el tipo de masa,
su grosor, el tipo de horno, tu placa o piedra de pizza, y si la pones
fría o caliente en el horno, tu pizza tardará más o menos en hacerse.
Debes descubrir el número mágico de minutos $\varphi$ que son necesarios
para cocinar perfectamente tu pizza en tu horno. Experimenta: prepara
varias pizzas idénticas, y cocínalas *una por una* distintas cantidades
$n$ de minutos, hasta que encuentres el punto."

Con la intención de seguir este último consejo al pie de la letra, he
preparado una cantidad arbitrariamente grande de pizzas para hacer en mi
barbacoa. Como no conozco el tiempo que tarda mi barbacoa en cocer una
pizza, seguiré el siguiente proceso.

- Pongo una de las pizzas en la barbacoa.

- Espero un número $n$ de minutos.

- Retiro la pizza, y espero exactamente $t$ minutos a que la pizza tenga
  la temperatura óptima para ser degustada.

- Pruebo la pizza.

Tardo $t+n$ minutos en aplicar estos pasos, al final de los cuales
descubriré:

- La pizza está perfecta: $n = \varphi$.

- La pizza está cruda: $n < \varphi$.

- La pizza está quemada: $n > \varphi$.

Asumiendo que ya sé de antemano que dedicando $n=a$ minutos obtendré una
pizza cruda, y que dedicando $n=b$ minutos se me quemará la pizza,
descubre qué proceso debería seguir para encontrar la mágica constante
$\varphi$. En concreto, te pido que realices un programa que, dados $a$,
$b$ y $t$, descubra una estrategia que minimice el número de minutos $M$
que perderé cocinando pizzas hasta descubrir $\varphi$, en el peor de
las situaciones contempladas por la estrategia. Tu programa deberá
escribir el número de minutos que perderé si se diera esa peor
circunstancia.

Por ejemplo, si $b=a+2$, es obvio que $\varphi = n$, por lo que la
respuesta es $M=0$. Si $b=a+3$, deberé cocinar al menos una pizza para
descubrir cuánto vale $\varphi$, por lo que $M=a+1+t$ (puestos a cocinar
una pizza, mejor pruebo la que tarda menos tiempo). Si $b=a+4$, entonces
$M=a+2+t$ (si eligiera $n=a+1$ y la pizza me quedara cruda, no sabría si
la respuesta es $\varphi=a+2$ o $\varphi=a+3$, por lo que tendría que
cocinar una segunda pizza). Cuando $b>a+4$, en el peor de los casos
tendré que preparar dos pizzas, y los cálculos se complican. En
particular, el tiempo $t$ tiene importancia: puede ser preferible
cocinar 2 pizzas poco tiempo que 1 pizza largo tiempo.

## Entrada

Una secuencia no vacía de líneas, cada una de las cuales se corresponde
con los 3 valores $t$, $a$ y $b$ de un caso, separados por espacios. Se
cumple $0\leq t\leq 200$, $0\leq a<b\leq 200$ y $b-a>1$.

## Salida

Escribe en una línea para cada caso el número de minutos que tardaré en
descubrir $\varphi$, asumiendo que sigo una estrategia que minimiza este
número.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T11:19:55.050Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
