# Gramàtiques

Una gramàtica consisteix en regles compostes per una o més produccions i
un o més símbols terminals. En aquest exercici suposarem que les
produccions comencen amb una lletra majúscula, i que la producció
inicial s'anomena \@I@. Per exemple, la gramàtica següent genera totes
les parentitzacions correctes (no buides):

::: NoShortVerb
  ------ ------- ------- --------- --------- --------- --------
  \@I@   $\to$   @( )@   $\vert$   @( I )@   $\vert$   \@I I@
  ------ ------- ------- --------- --------- --------- --------
:::

En aquest exemple, @( )@ es genera aplicant la primera regla, @( ( ) )@
es genera aplicant la segona regla i després la primera, @( ) ( )@ es
genera aplicant la tercera regla i després la primera dues vegades,
etcètera.

Suposem que \@lambda@ denota un símbol terminal especial buit. Usant
aquesta convenció, la gramàtica següent genera totes les paraules que
comencen amb \@a@ que contenen un nombre parell de \@a@s i un nombre
senar de \@b@s:

::: NoShortVerb
  ------- ------- ----------- --------- --------- --------- ---------
  \@I@    $\to$   \@a SS@                                   
  \@SS@   $\to$   \@a PS@     $\vert$   \@b SP@             
  \@SP@   $\to$   \@a PP@     $\vert$   \@b SS@             
  \@PS@   $\to$   \@a SS@     $\vert$   \@b PP@             
  \@PP@   $\to$   \@lambda@   $\vert$   \@a SP@   $\vert$   \@b PS@
  ------- ------- ----------- --------- --------- --------- ---------
:::

Feu un programa que escrigui $n$ termes generables amb una gramàtica
donada. Si una producció té $r$ regles (numerades de 0 a $r - 1$), per
decidir quina regla triar, feu servir un generador de nombres
pseudoaleatoris amb paràmetres $m$, $a$, $b$ i $s$, com està explicat a
l'exercici [**problem://problemsjutge.org:problems/i2/roura/camins-aleatoris.pbm**](https://jutge.org/problems/problem://problems\@jutge.org:problems/i2/roura/camins-aleatoris.pbm):

        int atzar(int r, int m, int a, int b, int& s) {
            s = (a*s + b)%m;
            return s%r;
        }

## Entrada

L'entrada comença amb un natural $p > 0$ que indica el nombre de
produccions. Cada producció comença amb el seu nom i el seu nombre de
regles $r > 0$. Cada regla es descriu amb un natural $m > 0$, seguit de
$m$ noms de produccions o de símbols terminals.

L'entrada acaba amb el nombre $n$ de termes que cal generar, seguit dels
quatre naturals $m$, $a$, $b$ i $s$ que defineixen el generador de
nombres pseudoaleatoris.

## Sortida

Escriviu $n$ línies, cadascuna amb el terme obtingut aplicant les regles
indicades pel generador de nombres pseudoaleatoris. Useu les produccions
d'esquerra a dreta dins de cada regla. Cada paraula ha d'estar precedida
d'un espai.

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T11:17:19.313Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
