# William Wilson

> 
>
> My namesake was born on precisely the day of my own nativity...The
> same name! The same contour of person!...And then his dogged and
> meaningless imitation of my gait, my voice, my habits, and my
> manner!... I plunged my sword, with brute ferocity, repeatedly through
> and through his bosom... "You have conquered, and I yield...In me
> didst thou exist---and, in my death, see by this image, which is thine
> own, how utterly thou hast murdered thyself."

William murdered his alter-ego (let us call him $X$), so similar to
William that they could be twin brothers. To find out, William gathered
information about his own family and about the family of $X$. William
got a tree with the most notorious physical characteristics of some of
his ancestors, each codified with a natural number. The characteristic
of William is at the root. For each node, its left child contains the
characteristic of its father, while its right child contains the
characteristic of its mother. (For instance, if William's genealogical
tree is the first tree below, and a 2 codifies having green eyes, then
the mother of the father of William had green eyes.)

$$\pstree[levelsep=31pt,treesep=15pt]{\Tcircle{\mbox{\small 3}}}{
  \pstree{\Tcircle{\mbox{\small 0}}}
  {
    \pstree{\Tcircle{\mbox{\small 7}}}
    {
      \Tn
      \Tcircle{\mbox{\small 4}}
    }
    \pstree{\Tcircle{\mbox{\small 2}}}
    {
      \Tn
      \Tn
    }
  }
  \pstree{\Tcircle{\mbox{\small 5}}}
  {
    \pstree{\Tcircle{\mbox{\small 4}}}
    {
      \Tn
      \Tn
    }
    \pstree{\Tcircle{\mbox{\small 7}}}
    {
      \pstree{\Tcircle{\mbox{\small 7}}}
      {
        \Tn
        \Tn
      }
      \Tn
    }
  }
}
\hspace{1.5cm}
\pstree[levelsep=31pt,treesep=15pt]{\Tcircle{\mbox{\small 3}}}{
  \pstree{\Tcircle{\mbox{\small 5}}}
  {
    \pstree{\Tcircle{\mbox{\small 4}}}
    {
      \Tn
      \Tn
    }
    \pstree{\Tcircle{\mbox{\small 7}}}
    {
      \Tn
      \pstree{\Tcircle{\mbox{\small 7}}}
      {
        \Tn
        \Tn
      }
    }
  }
  \pstree{\Tcircle{\mbox{\small 0}}}
  {
    \pstree{\Tcircle{\mbox{\small 2}}}
    {
      \Tn
      \Tn
    }
    \pstree{\Tcircle{\mbox{\small 7}}}
    {
      \Tn
      \Tcircle{\mbox{\small 4}}
    }
  }
}
\vspace*{-0.3cm}$$

Unfortunately, William does not know the gender of any of the ancestors
of $X$, so he draws them left or right arbitrarily in $X$'s tree. (For
instance, if $X$'s tree is the second tree above, then any of the four
grandparents of $X$ could have green eyes.) Consequently, William has
decided to consider $X$ his twin brother if and only if it is possible
to transform $X$'s tree into William's tree by repeatedly choosing any
of its nodes and swapping its two children.

Please write a program to decide if two given genealogical trees can
correspond to twin brothers, according to William's convention.

## Input

Input consists of several cases. Every case begins with its two names,
made up of only letters. Follow two binary trees, described with their
respective preorders, using -1 to mark empty subtrees. Each given tree
has at most $2^{10}$ nodes.

## Output

For every case, print the correct answer.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T11:16:20.240Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
