# Chariots of fire

Telecommunication engineering is tough. Every year, students learn how
to apply the rules of equivalent resistance:

- Series setting: If you have two resistors connected one after the
  other, without any other connection in the middle, the equivalent
  resistance from the beginning of the first resistor to the end of the
  second resistor is just the sum of the two resistances.

- Parallel setting: If you have two resistors connected in parallel, so
  that both beginnings are connected together and both ends are
  connected together, the equivalent resistance is the inverse of the
  sum of the inverses of the resistances. The extension of this rule
  also applies if more than two resistors are connected in parallel.

Your professor here at UPC went nuts and now wants you to apply this set
of rules to a very complicated circuit of resistors. However, he swears
that you can resolve it with just these two formulas. He is even going
to tell you which resistors are connected in parallel and which in
series! In the old times it wasn't like that! Well ...

## Input

Input consists of several cases. Every case is a (perhaps *huge*) string
describing a circuit. An '`S`' begins a series setting, and a '`P`'
begins a parallel setting. Between parentheses there is a
comma-separated list with two or more descriptions for the subcircuits.
An '`R`', together with a strictly positive real number between
parentheses, describes each resistor. There are no spaces.

## Output

For every circuit, its equivalent resistance with three digits after the
decimal point. The cases have no precision issues.

## Problem information

Author: Ricardo Martín

Generation: 2026-01-25T11:14:58.845Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
