# Expressió booleana completament parentitzada

Feu un programa que llegeixi una expressió booleana completament
parentitzada, i que escrigui el resultat d'avaluar-la. Els operadors
admissibles són *conjunció* i *disjunció* (binaris) i *negació* (unari).

## Entrada

Els valors booleans es representen per '`0`' i '`1`'. La conjunció, la
disjunció i la negació es representen amb '', '`+`' i '`!`'
respectivament.

L'entrada és una expressió completament parentitzada. Això vol dir que
sempre apareixen parèntesis al voltant de les expressions amb operadors
binaris. Per exemple,

::: itemize*
l'expressió $\textit{cert}\land \textit{fals}$ vindria donada així:
`(1*0)`

l'expressió $\textit{fals}\lor (\textit{cert}\land \textit{fals})$
vindria donada així: `(0+(1*0))`

l'expressió
$\lnot(\textit{fals}\lor (\textit{cert}\land \textit{fals}))$ vindria
donada així: `!(0+(1*0))`
:::

## Sortida

Cal escriure el resultat d'avaluar l'expressió en una línia.

## Pista

Fixeu-vos que una expressió és d'una d'aquestes possibilitats:

::: itemize*
o bé és directament un dígit zero o u;

o bé és l'operador unari de negació, seguit d'una expressió;

o bé és un parèntesi obert, seguit d'una expressió, d'un operador
binari, d'una altra expressió, i d'un parèntesi tancat.
:::

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-01-25T11:08:10.608Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
