# Mutaciones de virus

Recordad que el código genético (véase problema P36671) es un conjunto
de reglas que traduce secuencias de nucleótidos a proteínas. Cuando se
trabaja con ADN en lugar de ARN mensajero, las secuencias de nucleótidos
cambian la base `U` por la base `T`.

A menudo, como reacción de resistencia contra los fármacos, los virus
mutan su ADN manteniendo su funcionalidad, es decir, sintetizando la
misma proteína. Por ejemplo, si un virus tuviera la secuencia

::: center
\(1\) `GCCAATGACTAAGGCCTAAAGA`
:::

entonces sintetizaría la proteína *Thr--Lys--Ala*. Si el virus mutara a
la secuencia (2)

::: center
\(1\) `GCCAATGAC`*`T`*`AAGGCCTAAAGA`\
(2) `GCCAATGAC`**`C`**`AACGCCTAAAGA`
:::

(solo ha cambiado la décima base), este continuaría sintetizando
*Thr--Lys--Ala*. En este caso, decimos que se ha producido una (o más)
mutaciones equivalentes.

En cambio, si el virus mutara a la secuencia (3)

::: center
\(1\) `GCCAATG`*`A`*`CTAAG`*`G`*`CCTAAAGA`\
(3) `GCCAATG`**`T`**`CTAAG`**`A`**`CCTAAAGA`
:::

(solo la octava y la decimocuarta bases), entonces sintetizaría
*Ser--Lys--Thr*, lo que se nota indicando `Thr-1-Ser,Ala-3-Thr` (el
número indica en qué codón se ha producido la mutación).

Hagan un programa que indique si pares de secuencias de ADN representan
mutaciones equivalentes y que, en caso negativo, indique qué mutaciones
se han producido. El programa también debe decir cuántas bases son
diferentes entre el codón `ATG` y el codón de *Stop*.

## Entrada

La entrada comienza con un natural $k$. Después, vienen $k$ pares de
secuencias de ADN de la misma longitud. Cada secuencia de ADN está
formada por una cadena de caracteres '`A`', '`C`', '`T`' y '`G`' en una
línea sin espacios.

Todas las secuencias de ADN tienen un codón `ATG` antes de un codón de
*Stop*. El codón `ATG` y el codón de *Stop* nunca mutan en ningún par de
secuencias ni ninguna mutación puede introducir un nuevo codón de
*Stop*. Los pares de secuencias siempre tienen la misma longitud.

## Salida

Para cada par de secuencias de ADN de la entrada, hay que indicar si son
o no son equivalentes. En el caso de que no sean equivalentes, hay que
indicar todos los cambios que han producido las mutaciones según la
notación estándar descrita anteriormente. El número de bases diferentes
se debe escribir al final de la línea, entre paréntesis.

Seguid el formato del ejemplo.

## Información del problema

Autoría: Unknown\
Traducción: Jordi Petit

Generación: 2026-01-25T11:06:22.649Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
