# Triangles de Sierpiński

El triangle de Sierpiński és un objecte fractal, que va ser introduït
per primera vegada en 1915 pel matemàtic polonès Waclaw Sierpiński. És
un dels exemples bàsics de conjunt auto-semblant, una de les propietats
fonamentals de les fractals.

Per pintar un triangle de Sierpiński de mida $m$ amb un sol nivell, cal
pintar un triangle equilàter de costat $m$. Per pintar un triangle de
Sierpiński de mida $m$ i $n\ge2$ nivells, cal pintar tres subtriangles
de Sierpiński de mida $m/2$ amb $n-1$ nivells. El segon triangle s'ha de
pintar a la dreta del vèrtex dret del primer, el tercer s'ha de pintar
al damunt del vèrtex superior del primer.

Per exemple, aquests són triangles de Sierpiński amb 1, 2, 3, 4, 5 i 6
nivells:

::: center
1      

4      
:::

## Entrada

A l'entrada, es dónen dos valors: un real positiu $m$ amb la mida del
triangle de Sierpiński, i un natural $n$ amb el seu nombre de nivells.

## Sortida

El programa ha de dibuixar un triangle de Sierpiński de mida $m$ amb $n$
nivells.

::: multicols
2

## Exemple d'entrada 1

    100
    2

## Exemple de sortida 1

![image](2.eps){height="4cm"}
:::

::: multicols
2

## Exemple d'entrada 2

    100
    5

## Exemple de sortida 2

![image](5.eps){height="4cm"}
:::

## Recordatori

Recordeu que Python ofereix un mòdul `turtle` que permet pintar images
amb una tortuga que es desplaça. Les úniques operacions que us calen són
`turtle.forward(m)` que avança la tortuga `m` unitats,
`turtle.backward(m)` que recula la tortuga `m` unitats,
`turtle.right(a)` que gira la tortuga `a` graus a la dreta i
`turtle.left(a)` que gira la tortuga `a` graus a l'esquerra. També,
podeu usar `turtle.speed(0)` per accelerar la tortuga. Per exemple,
aquest programa pinta un avorrit triangle:

::: small
    import turtle
    import yogi

    def triangle(m):
        for i in range(3):
            turtle.forward(m)
            turtle.left(120)

    turtle.speed(0)
    m = yogi.read(float)
    triangle(m)
:::

## Observacions

- Aquest problema no té jocs de proves al Jutge. Per tant, qualsevol
  solució serà acceptada: semàfor verd! Això no vol dir que sigui bona
  ni dolenta, el vostre professor ho corregirà.

- Perquè una solució sigui correcta no cal que cada segment es dibuixi
  una sola vegada.

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-01-25T11:02:16.185Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
