# Calculator

Your little sister has lost her pocket calculator just before an
important exam. She asks you to lend her your portable computer and to
write her a program to evaluate single expressions. Your fraternal love
is so big that you immediately agree on both things.

The calculator that your sister wishes is very simple: expressions can
only contain one-digit numbers and the four basic arithmetic operations
(where divisions should be understood as integer divisions). Parentheses
are also allowed. The calculator must honor the usual priority rules.
All operators have left-to-right associativity (just like in C++). All
expressions strictly adhere to the following syntax:

$$\begin{align*}
    \textsl{expression} & ~\rightarrow~ \textsl{expression} \texttt{ + } \textsl{term}
        ~|~ \textsl{expression} \texttt{ - } \textsl{term} ~|~ \textsl{term} \\
    \textsl{term} & ~\rightarrow~ \textsl{term} \texttt{ * } \textsl{factor}
        ~|~ \textsl{term} \texttt{ / } \textsl{factor} ~|~ \textsl{factor} \\
    \textsl{factor} & ~\rightarrow~ \textsl{number} ~|~
        \texttt{( } \textsl{expression} \texttt{ ) } \\
    \textsl{number} & ~\rightarrow~
       \texttt{0}  ~|~ 
       \texttt{1}  ~|~ 
       \texttt{2}  ~|~ 
       \texttt{3}  ~|~ 
       \texttt{4}  ~|~ 
       \texttt{5}  ~|~ 
       \texttt{6}  ~|~ 
       \texttt{7}  ~|~ 
       \texttt{8}  ~|~ 
       \texttt{9}  
\end{align*}$$

## Input

Input consists of several expressions following the grammar above, with
no spaces at all. No expression has more than 2000 characters. You have
the guarantee that no division by 0 will ever occur, and that no final
nor intermediate result will overflow in a 32-bit `int`.

## Output

For every expression, print the result of its evaluation.

## Problem information

Author: Jordi Petit

Generation: 2026-01-25T11:01:53.068Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
