# Haskell --- Salts de cavall

Considerem un cavall en un tauler de $8\times8$ escacs buits. La seva
posició es pot donar amb una tupla que indiqui la seva fila i la seva
columna:

        type Pos = (Int, Int)       -- la casella inferior esquerra és (1,1)

Recordeu que els cavalls es mouen en \"L\":

::: center
![image](cavall.eps){width="4cm"}
:::

1.  Definiu una funció `dins :: Pos -> Bool` que, donada una posició
    d'un cavall, retorni si aquesta és dins del tauler.

2.  Definiu una funció `moviments :: Pos -> [Pos]` que, donada una
    posició d'un cavall dins del tauler, retorni la llista de posicions
    dins del tauler on es pot trobar després d'un salt.

    L'ordre de la llista no és important: Els jocs de proves ja
    l'ordenen amb *sort*. Però heu d'escriure `import Data.List (sort)`
    al principi del vostre programa.

3.  Definiu una funció `potAnar3 :: Pos -> Pos -> Bool` que, donada una
    posició inicial `p` dins del tauler i una posició final `q`, digui
    si un cavall pot anar de `p` a `q` en (exactament) tres salts.

4.  Definiu ara una funció `potAnar3' :: Pos -> Pos -> Bool` que faci el
    mateix que `potAnar3` però trient partit del fet que les llistes són
    instància de `Monad`.

A l'hora de corregir es tindrà en compte la correcció, consició,
senzillesa, claredat, elegància i l'ús de les eines de programació
funcional de la solució proposada. En aquest problema, l'eficiència és
poc important.

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-02-03T17:08:13.688Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
