# Filesystem

Your computer filesystem is a tree with several directories. Initially,
you only have the root directory "`/`". A filepath describes a path from
"`/`" to a directory, using slashes to separate directories. For
instance, "`/`": only the root; "`/dev/`": "`dev`" inside the root;
"`/pictures/travel/porto/`": "`porto`" inside "`travel`" inside
"`pictures`" inside the root.

You have three commands to change the filesystem:

- `make` *filepath*: Creates the minimum number of directories to make
  *filepath* valid.

- `erase` *filepath*: Removes the directory described by *filepath* and
  all its content. You can assume that *filepath* always exists.

- `move` *src* *dst*: Moves the directory *src* and all its content
  inside the directory *dst*. You can assume that *src* and *dst* exist,
  that *src* and *dst* are different, and that *dst* is not a
  subdirectory of *src*.

Additionally, assume that the root will never be moved nor removed. But
you can `make /`.

Given a list of commands, print the whole filesystem with an indented
tree as shown in the sample outputs. List the children of every
directory in alphabetical order.

## Input

Input consists of between 1 and a few thousand commands. The directory
names consist of between 1 and 8 lowercase letters. Every command will
create a small number of new directories, if any. At every moment, the
tree will not be "too large" nor "too high".

## Output

After every command, print a line with 20 dashes followed by the
filesystem tree.

## Problem information

Author: Albert Martínez

Generation: 2026-01-25T10:38:48.255Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
