# Lazy Snakes and Ladders

*Snakes and Ladders* has amused children for generations. So, after the
failure of his fifth start-up on a row, Edgar Hausdorff decides to go
with that theme for the first app of his newly founded Hausdorff Space
mobile game development company. The rules are simple:

0.60

- Players red and blue start with their counters on cell number 1, and
  take turns in rolling a six-sided die, with red going first.

- The counter for the current player moves forward the number of cells
  rolled in the die (e.g., rolling a 5 when on cell 4 takes the counter
  to 9).

- The goal is to reach the cell 100. An exact roll is needed: in case of
  excess, the counter *bounces* and moves the extra count backwards
  (e.g., rolling a 5 when on cell 97 takes the counter to 98).

0.40

::: center
![image](board.eps){width="5.5cm"}
:::

- If the landing cell (after potential bouncing) is the bottom of a
  ladder, the counter is moved to its top, which will be a
  higher-numbered cell (e.g., rolling a 1 when on cell 1 takes the
  counter to 38). Nothing happens when the counter directly lands on a
  top.

- If the landing cell (after potential bouncing) is the head of a snake,
  the counter is moved to its tail, which will be a lower-numbered one
  (e.g., rolling a 3 when on cell 98 takes the counter to 80). Nothing
  happens when the counter directly lands on a tail.

- If the rolled number was six, the player keeps the turn; otherwise, it
  passes to the other player (irrespective of whether bouncing, snakes,
  or ladders were involved).

However, Hausdorff's lack of coding skills and moral decency makes him
cut corners when implementing the code for die rolling. He grabs a real
die, rolls it $n$ times writing down each outcome $r_i$, and implements
the rolls in the game by returning those values in cyclic sequence.
Using the board depicted in the image, can you tell the winner given the
numbers that Hausdorff rolled? Every given case is guaranteed to
eventually finish.

## Input

Input consists of several cases, each with $n$ followed by the $r_i$'s,
with $1 \le r_i \le 6$.

## Output

For each case, print "`RED`" or "`BLUE`" depending on the winner.

## Problem information

Author: Edgar Gonzàlez

Generation: 2026-01-25T10:34:46.368Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
