# Swapping parentheses

Let ${\cal P}_n$ be the set of words with exactly $n$ opening
parentheses and $n$ closing parentheses, such that every '`)`' matches a
'`(`'. For instance, $${\cal P}_3 \enspace = \enspace \{
\enspace \mbox{``\texttt{\small ((()))}''} \enspace,
\enspace \mbox{``\texttt{\small (()())}''} \enspace,
\enspace \mbox{``\texttt{\small (())()}''} \enspace,
\enspace \mbox{``\texttt{\small ()(())}''} \enspace,
\enspace \mbox{``\texttt{\small ()()()}''} \enspace
\} \enspace .$$

Consider the following experiment: Choose one word $w$ from ${\cal P}_n$
at random. Then, pick one '`(`' and one '`)`' of $w$, independently at
random, and swap them. What is the probability that the result is also a
word in ${\cal P}_n$?

For example, let $n = 3$. If we choose $w =$ "`((()))`", then there are
exactly four swaps that produce a word in ${\cal P}_3$, namely 2-4, 2-5,
3-4, 3-5. The rest of swaps (1-4, 1-5, 1-6, 2-6, 3-6) are incorrect.
Each of the other words in ${\cal P}_3$ has three correct swaps.
Therefore, the probability for $n = 3$ is $$\frac{1}{5} \left(
\frac{4}{9} + \frac{3}{9} + \frac{3}{9} + \frac{3}{9} + \frac{3}{9}
\right)
= \frac{16}{45}
\simeq 0.355556
\enspace .$$

## Input

Input consists of several integer numbers $n$ between 1 and 30.

## Output

For every given $n$, print with six digits after the decimal point the
probability that swapping a random '`(`' with a random '`)`' of a random
word in ${\cal P}_n$ produces a word also in ${\cal P}_n$.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T10:33:29.478Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
