# Haskell --- Binary tree

In this problem you have to write several functions for generic binary
trees. The definition of the trees is given by:

        data Tree a = Node a (Tree a) (Tree a) | Empty deriving (Show)

That is, a tree with elements of type $a$ is, either an empty tree,
either a node with an element (of type $a$) and two other trees of the
same type. The `deriving (Show)` statement simply enables an
visualization of trees.

1.  Write a function `size :: Tree a -> Int` that, given a tree, returns
    its size, that is, the number of node it contains.

2.  Write a function `height :: Tree a -> Int` that, given a tree,
    returns its height, assuming that empty trees have zero height.

3.  Write a function `equal :: Eq a => Tree a -> Tree a -> Bool` that,
    given two trees, tells whether they are the same.

4.  Write a function `isomorphic :: Eq a => Tree a -> Tree a -> Bool`
    that, given two trees, tells whether they are isomorphic, that is,
    if one can obtain one from the other flipping some of its
    descendants.

5.  Write a function `preOrder :: Tree a -> [a]` that, given a tree,
    return its pre-order traversal.

6.  Write a function `postOrder :: Tree a -> [a]` that, given a tree,
    return its post-order traversal.

7.  Write a function `inOrder :: Tree a -> [a]` that, given a tree,
    return its in-order traversal.

8.  Write a function `breadthFirst :: Tree a -> [a]` that, given a tree,
    return its traversal by levels.

9.  Write a function `build :: Eq a => [a] -> [a] -> Tree a` that, given
    a pre-order traversal of a tree and an in-order traversal of the
    same tree, returns the original tree. You can assume that the three
    has no repeated elements.

10. Write a function
    `overlap :: (a -> a -> a) -> Tree a -> Tree a -> Tree a` that, given
    two trees, returns its overlapping using a function. Overlapping two
    trees with a function consists in placing the two trees one on the
    other and combine the double nodes using the given function.

## Scoring

Each function scores 10 points.

## Problem information

Author: Unknown\
Translator: Jordi Petit

Generation: 2026-02-03T17:09:41.885Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
