# Haskell --- Arbre binari

Aquest problema planteja l'escriptura de diverses funcions sobre arbres
binaris genèrics. La definició dels arbres ve donada per:

        data Tree a = Node a (Tree a) (Tree a) | Empty deriving (Show)

És a dir, un arbre amb elements de tipus $a$ és, o bé un arbre buit, o
bé un node que arrela un element (de tipus *a*) amb dos altres arbres.
La declaració `deriving (Show)` permet mostrar els arbres senzillament.

1.  Feu una funció `size :: Tree a -> Int` que, donat un arbre, retorni
    la seva talla, és a dir, el nombre de nodes que conté.

2.  Feu una funció `height :: Tree a -> Int` que, donat un arbre,
    retorni la seva alçada, assumint que els arbres buits tenen alçada
    zero.

3.  Feu una funció `equal :: Eq a => Tree a -> Tree a -> Bool` que,
    donat dos arbres, indiqui si són el mateix.

4.  Feu una funció `isomorphic :: Eq a => Tree a -> Tree a -> Bool` que,
    donat un arbres, indiqui si són el isomorfs, és a dir, si es pot
    obtenir l'un de l'altre tot girant algun dels seus fills.

5.  Feu una funció `preOrder :: Tree a -> [a]` que, donat un arbre,
    retorni el seu recorregut en pre-ordre.

6.  Feu una funció `postOrder :: Tree a -> [a]` que, donat un arbre,
    retorni el seu recorregut en post-ordre.

7.  Feu una funció `inOrder :: Tree a -> [a]` que, donat un arbre,
    retorni el seu recorregut en in-ordre.

8.  Feu una funció `breadthFirst :: Tree a -> [a]` que, donat un arbre,
    retorni el seu recorregut per nivells.

9.  Feu una funció `build :: Eq a => [a] -> [a] -> Tree a` que, donat el
    recorregut en pre-ordre d'un arbre i el recorregut en in-ordre del
    mateix arbre, retorni l'arbre original. Assumiu que l'arbre no té
    elements repetits.

10. Feu una funció
    `overlap :: (a -> a -> a) -> Tree a -> Tree a -> Tree a` que, donats
    dos arbres, retorni la seva superposició utilitzant una funció.
    Superposar dos arbres amb una funció consisteix en posar els dos
    arbres l'un damunt de l'altre i combinar els nodes doble resultants
    amb la funció donada o deixant els nodes simples tal qual.

## Puntuació

Cada apartat puntua 10 punts.

## Informació del problema

Autoria: Jordi Petit

Generació: 2026-02-03T17:09:46.854Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
