# Fermat's last theorem (1)

A famous theorem of the mathematician Pierre de Fermat, proved after
more than 300 years, states that, for any natural number $n\ge 3$, there
is no natural solution (except for $x= 0$ or $y= 0$) to the equation
$$x^{n} + y^{n} = z^{n} .$$ For $n= 2$, by contrast, there are infinite
non-trivial solutions. For instance, $3^2 + 4^2 = 5^2$,
$5^2 + 12^2 = 13^2$, $6^2 + 8^2 = 10^2$, ....

Write a program that, given four natural numbers $a,b,c,d$ with $a\le b$
and $c\le d$, prints a natural solution to the equation
$$x^2 + y^2 = z^2$$ such that $a\le x\le b$ and $c\le y\le d$.

## Input

Input consists of four natural numbers $a, b, c, d$ such that $a\le b$
and $c\le d$.

## Output

Print a line following the format of the examples, with a natural
solution to the equation $$x^2 + y^2 = z^2$$ that fulfills $a\le x\le b$
and $c\le y\le d$. If there is more than one solution, print the one
with the smallest $x$. If there is a tie in $x$, print the solution with
the smallest $y$. If there are no solutions, print "`No solution!`".

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T10:29:07.862Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
