# Simulació d'un ecosistema

Considereu un tauler $n \times m$ on cada casella conté un individu
d'una certa espècie amb una certa quantitat de vida (un natural). A cada
torn, es modifiquen alhora les vides de tots els individus. Per a
cadascun, la nova vida passa a ser la mitjana de vides d'aquest conjunt:
el propi individu, més els individus que en siguin adjacents
horitzontalment o verticalment i siguin d'una espècie diferent. Si la
mitjana obtinguda no és un nombre natural, cal ignorar els decimals.

Per exemple, considereu l'home amb vida 10 del segon cas del sample. A
sobre no té res, i a l'esquerra té un altre home. Té dos veïns d'una
altra espècie: un gos amb vida 10 a la dreta, i un gat amb vida 9 a sota
seu. Per tant, la vida de l'home després del primer torn passa a ser
$\lfloor (10 + 10 + 9)/3 \rfloor
= \lfloor 9.667 \rfloor
= 9$.

Feu un programa que llegeixi la informació inicial d'un tauler, i que
escrigui la seva evolució fins arribar a una situació estable (suposeu
que sempre s'hi arriba).

El vostre codi ha d'incloure i usar aquesta definició:

        struct Casella {
            string e; // especie
            int v;    // vida
        };

## Entrada

L'entrada consisteix en diversos casos, cadascun amb $n$ i $m$, seguides
de $n$ línies, cadascuna amb l'espècie (una paraula no buida) i la vida
inicial de $m$ individus.

## Sortida

Per a cada cas, escriviu la seva evolució fins arribar a una situació
estable, seguint el format dels exemples: totes les columnes tenen 10
caràcters, hi ha una línia buida després de cada tauler, i una línia amb
40 asteriscs al final de cada cas. Suposeu que la combinació de la
longitud del nom de l'espècie i la quantitat de vida sempre és prou
petita com per poder seguir el format requerit.

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T10:23:28.429Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
