# Intérprete

Hacer un programa que simule la ejecución de un programa escrito en un
cierto lenguaje ensamblador (Apodado cariñosamente Rourix en honor a su
inventor). En este lenguaje, se dispone exclusivamente de 100 variables
de tipo entero, $x_0 \dots x_{99}$, todas inicialmente con el valor 1.
Las instrucciones del programa se encuentran guardadas consecutivamente
en posiciones etiquetadas $000, 001, 002, \dots$ (hasta un máximo de
999). El conjunto de instrucciones posibles es:

:::: center
::: NoShortVerb
  ----------------------- -----------------------------------------------------------------
  `stop`                  detiene el programa.
  `endl`                  escribe un salto de línea.
  `prin` $i$              escribe, precedido de un espacio, el contenido de $x_i$.
  `stor` $i$ $v$          guarda el valor $v$ en la variable $x_i$ ($x_i:=v$).
  `copy` $i$ $j$          copia $x_j$ en $x_i$ ($x_i:=x_j$).
  `acum` $i$ $j$          acumula $x_j$ en $x_i$ ($x_i:=x_i+x_j$).
  `subs` $i$ $j$          resta $x_j$ de $x_i$ ($x_i:=x_i-x_j$).
  `prod` $i$ $j$          multiplica $x_i$ por $x_j$ ($x_i:=x_i * x_j$).
  `goto` $\ell$           salta a la instrucción de la posición $\ell$.
  `jzer` $i$ $\ell$       salta a la instrucción de la posición $\ell$ sólo si $x_i = 0$.
  `jneg` $i$ $\ell$       salta a la instrucción de la posición $\ell$ sólo si $x_i < 0$.
  ----------------------- -----------------------------------------------------------------
:::
::::

El programa siempre se empieza a ejecutar desde la posición 000. Después
de ejecutar la instrucción de una posición $p$, se pasa a ejecutar la
siguiente instrucción (la de la posición $p + 1$, la cual si se ha de
ejecutar siempre existirá), excepto como es lógico con `stop`, `goto`, y
`jzer` o `jneg` cuando las condiciones para saltar son ciertas.

Todas las $i$ y $j$ del programa estarán entre 0 y 99. Todas las $\ell$
son líneas de programa válidas. Al ejecutar un programa, siempre se
encontrará un `stop` en algún momento.

## Entrada

La entrada consiste en un programa correcto en ensamblador, de entre 1 y
1000 líneas. Cada línea empieza con tres dígitos redundantes que indican
su número empezando por 000, seguidos de un espacio, y de la instrucción
correspondiente a esa línea. Los campos de cada instrucción también
están separados por un espacio. Todas las direcciones de salto $\ell$
tienen exactamente tres dígitos.

## Salida

Hay que escribir lo mismo que escribiría el programa en ensamblador.

## Pista

Es suficiente con tener una tabla para almacenar las 100 variables, otra
tabla para almacenar el programa, y un índice que indica cual es la
instrucción que se ha de ejecutar a continuación.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T10:18:15.639Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
