# Interpreter

Your task is to write a program that simulates the execution of a
program written in a certain assembly language (called affectionately
Rourix in honor of its inventor). In this language, 100 variables of
integer type are exclusively used, $x_0 \dots x_{99}$, all of them
initially with the value 1. The instruction of the program are
consecutively stored in labeled postitions $000, 001, 002, \dots$ (at
most 999). The set of possible instructions is:

:::: center
::: NoShortVerb
  ----------------------- --------------------------------------------------------------------
  `stop`                  stops the program.
  `endl`                  writes an end of line.
  `prin` $i$              writes, preceded of a space, the content of $x_i$.
  `stor` $i$ $v$          stores the value $v$ in the variable $x_i$ ($x_i:=v$).
  `copy` $i$ $j$          copies $x_j$ in $x_i$ ($x_i:=x_j$).
  `acum` $i$ $j$          accumulates $x_j$ in $x_i$ ($x_i:=x_i+x_j$).
  `subs` $i$ $j$          substracts $x_j$ of $x_i$ ($x_i:=x_i-x_j$).
  `prod` $i$ $j$          multiplies $x_i$ by $x_j$ ($x_i:=x_i * x_j$).
  `goto` $\ell$           jumps to the instruction of the position $\ell$.
  `jzer` $i$ $\ell$       jumps to the instruction of the position $\ell$ only if $x_i = 0$.
  `jneg` $i$ $\ell$       jumps to the instruction of the position $\ell$ only if $x_i < 0$.
  ----------------------- --------------------------------------------------------------------
:::
::::

The program always starts to execute from the position 000. After
executing the instruction of a position $p$, it goes to the following
instruction (the one in the position $p + 1$, which if has to be
executed will always exist), except, obviously, with `stop`, `goto`, and
`jzer` or `jneg` when the conditions to jump are true.

All the $i$ and $j$ of the program will be between 0 and 99. All the
$\ell$ are valid lines of program. Executing a program, it will always
find a \|stop\| in some moment.

## Input

The input consists of a correct program in assembly language, between 1
and 1000 lines. Each line starts with three redundant digits that
indicate its number starting with 000, followed by a space, and the
instruction corresponding to that line. The fields of each instruction
are also separated by a space. All the directions of jump $\ell$ have
exactly three digits.

## Output

Your program must print the same that would print the program in
assembler.

## Hint

Having a table to store the 100 variable is enough, another table to
store the program, and an index that indicates which is the instruction
that must be executed imediately after.

## Problem information

Author: Unknown\
Translator: Carlos Molina

Generation: 2026-01-25T10:18:20.313Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
