# Conecta 4

¿Conocéis el juego del conecta 4? Es como el cuatro-en-raya, pero no
puedes marcar cualquier casilla que te venga en gana: sólo puedes dejar
caer tus fichas en un tablero sostenido verticalmente.

![image](conecta4){width="40%"}

::: center
*Si tenéis uno en casa, probablemente no sea tan grande.*
:::

En este problema te pedimos que programes un simulador de conecta 4 como
el de la figura (6 filas y 8 columnas). Tu tu programa recibirá,
alternativamente, las columnas (1-8) por las que se dejan caer las
fichas de color rojo y amarillo, y deberá descubrir cuándo se forman
cuatro fichas en línea (horizontal, vertical o diagonal) del mismo
color.

## Entrada

Una secuencia de movimientos (números del 1 al 8) separados por espacios
o saltos de línea. Pueden haber líneas vacías (líneas sin dígitos ni
espacios) pero no habrá ninguna línea que contenga únicamente espacios.

## Salida

Tu programa deberá interpretar los movimientos de los jugadores,
empezando por rojo. Además, deberá escribir `INVALID` si se da un
movimiento inválido (intentar poner una ficha en una columna ocupada);
escribir `CONNECT4` si se forma un cuatro-en-raya; escribir `FULL` si el
tablero se llena sin haberse formado un cuatro-en-raya; y escribir
`QUIT` si la salida acaba antes de haberse formado un cuatro-en-raya o
haberse llenado el tablero.

Los movimientos inválidos deben ser ignorados (el jugador que comete el
movimiento inválido no pierde el turno). Cada vez que encuentres una
línea en blanco, escribe el estado actual del tablero, tal y como se
muestra en los ejemplos. Escribe también el tablero por la salida justo
después de producirse un `CONNECT4` o un `FULL`, e ignora el resto de la
entrada.

## Información del problema

Autoría: Omer Giménez

Generación: 2026-01-25T10:16:52.087Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
