# Seqüències pseudo-aleatòries

Sigui $y \; (\bmod m)$ l'equivalent matemàtic de `y%m` en C++. Una
manera habitual d'aconseguir una seqüència de nombres pseudo-aleatoris
consisteix a triar tres naturals $a$, $b$ i $m$, i un nombre inicial
$x_0$, i calcular cada $x_{i+1}$ a partir d'$x_i$, fent servir aquesta
igualtat: $$x_{i+1} = (a \cdot x_i + b)\pmod{m} \enspace .$$

Algunes combinacions produeixen seqüències que poden semblar realment
aleatòries. Per exemple, amb $a = 10$, $b = 7$, $m = 23$, i $x_0 = 4$,
obtenim 4, 1, 17, 16, 6, 21, 10, 15, ... Però amb $a = 2$, $b = 50$,
$m = 100$, i $x_0 = 0$ obtenim 0, 50, 50, 50, ...

Diverses mesures estadístiques sobre les seqüències generades en
permeten estimar com s'assemblen a seqüències realment aleatòries. Feu
un programa que en calculi algunes: la mitjana dels nombres obtinguts,
la longitud de la subseqüència consecutiva estrictament creixent més
llarga, i la longitud de la subseqüència consecutiva estrictament
decreixent més llarga.

## Entrada

L'entrada consisteix en diversos casos, cadascuna amb cincs naturals
$a$, $b$, $m$, $x_0$ i $p$. Aquest últim és el nombre d'elements de la
seqüència que cal generar. Suposeu $2 \le m \le 30000$, que $a$, $b$ i
$x_0$ es troben entre 0 i $m - 1$, i $p \ge 1$.

## Sortida

Per a cada cas, escriviu les tres quantitats demanades, la primera amb
dos decimals de precisió. Per fer-ho, poseu aquestes dues línies al
principi del vostre main:

        cout.setf(ios::fixed);
        cout.precision(2);

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T10:11:50.824Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
