# Fora de joc?

Ajudeu a visualitzar si una situació d'un partit de futbol és fora de
joc o no (amb les regles simplificades que s'expliquen més avall).
Aquesta és la descripció del terreny de joc:

- El terreny és de color '`Green`', i té dimensions $101 \times 71$.

- Totes les línies són rectes, horitzontals o verticals, de color
  '`White`'.

- Hi ha una línia vertical, amb $x = 50$, que divideix el terreny en
  dues meitats.

- Al costat esquerre, l'àrea gran està definida pels punts $(16, 16)$ i
  $(16, 54)$.

- Al costat esquerre, l'àrea petita està definida pels punts $(6, 25)$ i
  $(6, 45)$.

- Al costat dret, les dues àrees en són totalment simètriques.

- La circumferència central també és blanca, i té diàmetre 21.

L'equip B juga contra l'equip M. B ataca cap a l'esquerra. Coneixem les
posicions $(xb_i, yb_i)$ dels $n$ jugadors de camp de B. També coneixem
les posicions $(xm_i, ym_i)$ dels $m$ jugadors de camp de M. Suposem que
li han passat la pilota al jugador més avançat (amb la $x$ més petita)
de B. Sigui $x_1$ aquesta $x$. Sigui $x_2$ la $x$ del jugador més
endarrerit (també, amb la $x$ més petita) de M. Tenim tres casos:

- Si $x_1 > 50$, no hi pot haver fora de joc.

- Si $x_1 < 50$, n'hi ha si $x_1 < x_2$. Marqueu-ho pintant amb '`Red`'
  la gespa amb $x \le x_1$.

- Si $x_1 < 50$, no hi ha fora de joc si $x_1 > x_2$. Pinteu amb
  '`Orange`' la gespa amb $x \le x_2$.

A més, els jugadors de B s'ha de pintar de color '`Blue`', i els
jugadors de M, de color '`Magenta`', tots amb cercles de diàmetre 7
centrats a la posició de cada jugador.

## Entrada

L'entrada consisteix en $n$, $xb_1$, $yb_1$, ..., $xb_n$, $yb_n$, $m$,
$xm_1$, $ym_1$, ..., $xm_m$, i $ym_m$. Tant $n$ com $m$ estan entre 1 i
10, les $x$ estan entre 5 i 95, i les $y$ entre 5 i 65. A més, totes les
$x$ són diferents, $x_1 \ne 50$, i els cercles dels jugadors no se
solapen entre si.

## Sortida

Cal generar una imatge $(101, 71)$ amb els colors de fons adequats a la
situció dels jugadors, les ratlles i la circumferència central blanques,
i tots els cercles dels jugadors.

## Observacions

- Per evitar problemes amb els colors de fons (veieu l'exemple 2),
  dibuixeu el cercle amb

  ``` python
  dib.arc([40, 25, 60, 45], 0, 360, 'White')
  ```

- Una recta horitzontal no és més que un rectangle amb alçada 1, i
  similarment amb les rectes verticals.

## Informació del problema

Autoria: Víctor Martín

Generació: 2026-01-25T10:07:27.854Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
