# Pac-man

Ajudeu en Pac-man a saber com de lluny està de cada punt del seu món
$n \times m$. Suposeu que es mou així: Si es troba a $(x, y)$, en
general pot anar a $(x - 1, y)$, a $(x + 1, y)$, a $(x, y - 1)$ i a
$(x, y + 1)$. Però si es troba per exemple a $(0, y)$ (és a dir, a la
primera columna) i es mou a l'esquerra, apareix a $(n - 1, y)$. I passa
un fenomen similar si es mou des de l'última columna cap a la dreta, o
des de la primera fila cap amunt, o des de l'última fila cap avall. Amb
aquestes condicions, definim $d(P)$, la distància Pac-man de cada punt
$P$, com el mínim nombre de moviments que hauria de fer en Pac-man per
arribar a $P$ des de $(x, y)$.

## Entrada

L'entrada consisteix en sis enters $n$, $m$, $x$, $y$, $c$ i $p$. Podeu
suposar $n \ge 2$, $m \ge 2$, $0 \le x < n$, $0 \le y < m$, $c \ge 1$, i
$p \ge 1$.

## Sortida

Genereu una imatge $(n, m)$. Cal pintar cada punt $P$ amb color
$\text{Rainbow}(1529 - c \cdot d(P))$, on

$$\text{Rainbow}(z) = \left\{
\begin{array}{lcl}
    (255, z, 0) & \text{ si } & 0 \le z < 255, \\
    (510 - z, 255, 0) & \text{ si } & 255 \le z < 510, \\
    (0, 255, z - 510) & \text{ si } & 510 \le z < 765, \\
    (0, 1020 - z, 255) & \text{ si } & 765 \le z < 1020, \\
    (z - 1020, 0, 255) & \text{ si } & 1020 \le z < 1275, \\
    (255, 0, 1530 - z) & \text{ si } & 1275 \le z < 1530.
\end{array}
\right .$$

Finalment, la línia de codi

    dib.pieslice([x - p, y - p, x + p, y + p], 45, 315, 'Yellow')

dibuixa el Pac-man. Assumiu que aquest dibuix del Pac-man queda
completament dintre de la imatge, i que $c \cdot d(P)$ sempre és més
petit que 1530.

## Observació

Podeu obtenir 55 punts resolent casos on $n$ i $m$ són senars, i en
Pac-man es troba exactament al centre del dibuix, com l'Exemple
d'entrada 1.

## Informació del problema

Autoria: Víctor Martín

Generació: 2026-01-25T10:39:37.309Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
