# Subseqüències de dígits

Una seqüència $A = a_1$-$a_2$-\...-$a_m$ és una subseqüència d'una
seqüència $B = b_1$-$b_2$-\...-$b_n$, amb $m \le n$, si es pot
aconseguir $A$ escollint $m$ posicions de $B$, sense canviar-ne l'ordre
relatiu. Per exemple, 4-2 és una subseqüència de 2-4-0-2, 1-19 és una
subseqüència de 4-1-19, i 1-0-1-0-1-0 és una subseqüència de
1-1-0-1-0-0-1-0-0.

Sigui $R(x, b)$ la representació d'un nombre natural $x$ en base $b$,
separant els dígits amb guions. Per exemple, $R(42, 10) =$ 4-2,
$R(42, 23) =$ 1-19, i $R(42, 2) =$ 1-0-1-0-1-0.

Donats diversos parells de nombres naturals $x$ i $y$, trobeu totes les
bases $b$ per a les quals $R(x, b)$ té almenys dos dígits i és una
subseqüència d'$R(y, b)$.

## Entrada

L'entrada consisteix en diversos parells de naturals $x$ i $y$, amb
$1 < x < y < 10^9$.

## Sortida

Per a cada cas, escriviu en ordre i separades amb espais totes les bases
$b$ que compleixen la condició demanada. Amb les entrades donades,
sempre n'hi haurà almenys una.

## Observació

La vostra solució hauria d'implementar i fer servir una funció

        bool es_subsequencia(int x, int y, int b);

que digui si $R(x, b)$ és una subseqüència d'$R(y, b)$.

## Informació del problema

Autoria: Salvador Roura

Generació: 2026-01-25T10:35:21.405Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
