# Building a wall

Let us use right trapezoids to build a wall. Each trapezoid is defined
by four real parameters $\ell$, $r$, $y_\ell$ and $y_r$, which indicate
the points $(\ell, 0)$, $(\ell, y_\ell)$, $(r, y_r)$, and $(r, 0)$. For
instance, adding the trapezoids (1 5 1 3) and (7 11 1 3) into an empty
wall produces the figure to the left:

::::: center
::: pspicture
(13,8) (0,1)(13,1) (1,0)(1,7) (2,0)[1]{style="color: green"}
(3,0)[2]{style="color: green"} (4,0)[3]{style="color: green"}
(5,0)[4]{style="color: green"} (6,0)[5]{style="color: green"}
(7,0)[6]{style="color: green"} (8,0)[7]{style="color: green"}
(9,0)[8]{style="color: green"} (10,0)[9]{style="color: green"}
(11,0)[10]{style="color: green"} (12,0)[11]{style="color: green"}
(0,2)[1]{style="color: green"} (0,3)[2]{style="color: green"}
(0,4)[3]{style="color: green"} (0,5)[4]{style="color: green"}
(0,6)[5]{style="color: green"} (2,1)(2,2) (2,2)(6,4) (6,4)(6,1)
(8,1)(8,2) (8,2)(12,4) (12,4)(12,1)
:::

::: pspicture
(13,8) (0,1)(13,1) (1,0)(1,7) (2,0)[1]{style="color: green"}
(3,0)[2]{style="color: green"} (4,0)[3]{style="color: green"}
(5,0)[4]{style="color: green"} (6,0)[5]{style="color: green"}
(7,0)[6]{style="color: green"} (8,0)[7]{style="color: green"}
(9,0)[8]{style="color: green"} (10,0)[9]{style="color: green"}
(11,0)[10]{style="color: green"} (12,0)[11]{style="color: green"}
(0,2)[1]{style="color: green"} (0,3)[2]{style="color: green"}
(0,4)[3]{style="color: green"} (0,5)[4]{style="color: green"}
(0,6)[5]{style="color: green"} (2,1)(2,2) (2,2)(4,3) (4,3)(4,6)
(4,6)(6,6) (6,6)(6,3) (6,3)(8,2) (8,2)(8,3) (8,3)(10,3) (10,3)(12,4)
(12,4)(12,1)
:::
:::::

The material of the trapezoids is semifluid, so they adapt to the shape
underneath. For instance, adding (3 9 3 0) to the figure to the left
produces the figure to the right. Write a program to keep track of the
shape of an initially empty wall, with two kind of operations:

- '`A`' $\ell \enspace r \enspace y_\ell \enspace y_r$, to add a
  trapezoid as already explained.

- '`C`' $x$, to consult the current height of the wall at the abscissa
  $x$.

## Input

Input consists of several cases, each one with the number of operations
$n$, followed by those operations. Assume $1 \le n \le 10^5$, that all
given parametres are real numbers between 0 and $10^4$, $\ell < r$, and
that every $x$ is different to all previous $\ell$ and $r$.

## Output

For every '`C`' operation, print the height at $x$ with three digits
after the decimal point. The input cases do not have precision issues.

## Problem information

Author: Salvador Roura

Generation: 2026-01-25T10:33:22.027Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
