# Toric necklaces

A shop wants to commercialize a new kind of jewellery: toric necklaces!
Given an infinite supply of $k$ different beads, a toric necklace is
built by picking $n \cdot m$ beads and placing them on an $n\times m$
grid. Then we join every pair of beads that are vertically adjacent with
blue thread, and every pair of beads that are horizontally adjacent with
red thread. Finally, we use blue thread to join the $j$-th bead of the
first row with the $j$-th bead of the last row, and red thread to join
the $i$-th bead of the first column with the $i$-th bead of the last
column.

Here, we consider two toric necklaces equivalent if one can be obtained
from the other by horizontal and/or vertical rotations. In other words,
two necklaces defined by the matrices $A[0\ldots n-1,0\ldots m-1]$ and
$B[0\ldots n-1,0\ldots m-1]$ are equivalent if there exist $x$ and $y$
such that $A[i,j] = B[(i+x) \bmod n, (j+y) \bmod m]$ for every $i$ and
$j$.

Given $n$, $m$ and $k$, can you compute the number of different toric
necklaces?

## Input

Input consists of several different cases, each one with $n$, $m$ and
$k$, all between 1 and $10^6$.

## Output

For every case, print the number of $n\times m$ toric necklaces that can
be built with beads of $k$ different kinds, modulo $10^9 + 7$.

## Problem information

Author: Lander Ramos

Generation: 2026-01-25T10:30:40.031Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
